/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.testIntegration.RecentTestRunner;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationEntry;
import com.intellij.testIntegration.SingleTestEntry;
import com.intellij.testIntegration.SuiteEntry;
import com.intellij.testIntegration.TestEntryVisitor;
import com.intellij.testIntegration.TestLocator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RecentTestRunnerImpl
implements RecentTestRunner {
    private static AnAction RUN = ActionManager.getInstance().getAction("RunClass");
    private static AnAction DEBUG = ActionManager.getInstance().getAction("DebugClass");
    private final Project myProject;
    private final TestLocator myTestLocator;
    protected AnAction myCurrentAction = RUN;

    @Override
    public void setMode(RecentTestRunner.Mode mode) {
        switch (mode) {
            case RUN: {
                this.myCurrentAction = RUN;
                break;
            }
            case DEBUG: {
                this.myCurrentAction = DEBUG;
            }
        }
    }

    public RecentTestRunnerImpl(Project project2, TestLocator testLocator) {
        this.myProject = project2;
        this.myTestLocator = testLocator;
    }

    @Override
    public void run(RecentTestsPopupEntry entry) {
        entry.accept(new TestEntryVisitor(){

            @Override
            public void visitTest(@NotNull SingleTestEntry test) {
                RecentTestRunnerImpl.this.run(test.getUrl());
            }

            @Override
            public void visitSuite(@NotNull SuiteEntry suite) {
                RecentTestRunnerImpl.this.run(suite.getSuiteUrl());
            }

            @Override
            public void visitRunConfiguration(@NotNull RunConfigurationEntry configuration) {
                RecentTestRunnerImpl.this.run(configuration.getRunSettings());
            }
        });
    }

    private void run(RunnerAndConfigurationSettings configuration) {
        Executor executor = this.myCurrentAction == RUN ? DefaultRunExecutor.getRunExecutorInstance() : DefaultDebugExecutor.getDebugExecutorInstance();
        ProgramRunnerUtil.executeConfiguration(this.myProject, configuration, executor);
    }

    private void run(@NotNull String url) {
        final Location location = this.myTestLocator.getLocation(url);
        if (location == null) {
            return;
        }
        DataContext data = new DataContext(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (Location.DATA_KEY.is(dataId)) {
                    return location;
                }
                return null;
            }
        };
        this.myCurrentAction.actionPerformed(AnActionEvent.createFromAnAction((AnAction)this.myCurrentAction, null, (String)"", (DataContext)data));
    }
}

