/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.testIntegration.TestFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFinderHelper {
    public static PsiElement findSourceElement(@NotNull PsiElement from) {
        for (TestFinder each : TestFinderHelper.getFinders()) {
            PsiElement result2 = each.findSourceElement(from);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public static Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (TestFinder each : TestFinderHelper.getFinders()) {
            result2.addAll(each.findTestsForClass(element));
        }
        return result2;
    }

    public static Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        for (TestFinder each : TestFinderHelper.getFinders()) {
            result2.addAll(each.findClassesForTest(element));
        }
        return result2;
    }

    public static boolean isTest(PsiElement element) {
        if (element == null) {
            return false;
        }
        for (TestFinder each : TestFinderHelper.getFinders()) {
            if (!each.isTest(element)) continue;
            return true;
        }
        return false;
    }

    public static TestFinder[] getFinders() {
        return (TestFinder[])Extensions.getExtensions((ExtensionPointName)TestFinder.EP_NAME);
    }

    public static Integer calcTestNameProximity(String className, String testName) {
        int posProximity = testName.indexOf(className);
        int sizeProximity = testName.length() - className.length();
        return posProximity + sizeProximity;
    }

    public static List<PsiElement> getSortedElements(List<Pair<? extends PsiNamedElement, Integer>> elementsWithWeights, boolean weightsAscending) {
        return TestFinderHelper.getSortedElements(elementsWithWeights, weightsAscending, null);
    }

    public static List<PsiElement> getSortedElements(List<Pair<? extends PsiNamedElement, Integer>> elementsWithWeights, boolean weightsAscending, @Nullable Comparator<PsiElement> sameNameComparator) {
        Collections.sort(elementsWithWeights, (o1, o2) -> {
            int result2;
            int n = result2 = weightsAscending ? ((Integer)o1.second).compareTo((Integer)o2.second) : ((Integer)o2.second).compareTo((Integer)o1.second);
            if (result2 == 0) {
                result2 = Comparing.compare((Comparable)((Object)((PsiNamedElement)o1.first).getName()), (Comparable)((Object)((PsiNamedElement)o2.first).getName()));
            }
            if (result2 == 0 && sameNameComparator != null) {
                result2 = sameNameComparator.compare((PsiElement)o1.first, (PsiElement)o2.first);
            }
            return result2;
        });
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elementsWithWeights.size());
        for (Pair<? extends PsiNamedElement, Integer> each : elementsWithWeights) {
            result2.add((PsiElement)each.first);
        }
        return result2;
    }

    public static List<Pair<String, Integer>> collectPossibleClassNamesWithWeights(String testName) {
        String[] words = NameUtil.splitNameIntoWords((String)testName);
        ArrayList<Pair<String, Integer>> result2 = new ArrayList<Pair<String, Integer>>();
        for (int from = 0; from < words.length; ++from) {
            for (int to = from; to < words.length; ++to) {
                result2.add((Pair<String, Integer>)new Pair((Object)StringUtil.join((String[])words, (int)from, (int)(to + 1), (String)""), (Object)(words.length - from + to)));
            }
        }
        return result2;
    }
}

