/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestRunLineMarkerProvider
extends RunLineMarkerContributor {
    @Override
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement e) {
        if (this.isIdentifier(e)) {
            TestFramework framework;
            PsiClass psiClass;
            TestFramework framework2;
            PsiElement element = e.getParent();
            if (element instanceof PsiClass && (framework2 = TestFrameworks.detectFramework((PsiClass)((PsiClass)element))) != null && framework2.isTestClass(element)) {
                String url = "java:suite://" + ClassUtil.getJVMClassName((PsiClass)((PsiClass)element));
                return TestRunLineMarkerProvider.getInfo(url, e.getProject(), true);
            }
            if (element instanceof PsiMethod && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) != null && (framework = TestFrameworks.detectFramework((PsiClass)psiClass)) != null && framework.isTestMethod(element)) {
                String url = "java:test://" + ClassUtil.getJVMClassName((PsiClass)psiClass) + "." + ((PsiMethod)element).getName();
                return TestRunLineMarkerProvider.getInfo(url, e.getProject(), false);
            }
        }
        return null;
    }

    @NotNull
    private static RunLineMarkerContributor.Info getInfo(String url, Project project2, boolean isClass) {
        Icon icon = TestRunLineMarkerProvider.getTestStateIcon(url, project2, isClass);
        return new RunLineMarkerContributor.Info(icon, ExecutorAction.getActions(1), RunLineMarkerContributor.RUN_TEST_TOOLTIP_PROVIDER);
    }

    protected boolean isIdentifier(PsiElement e) {
        return e instanceof PsiIdentifier;
    }

    private static Icon getTestStateIcon(String url, Project project2, boolean isClass) {
        TestStateInfo.Magnitude magnitude;
        TestStateStorage.Record state = TestStateStorage.getInstance(project2).getState(url);
        if (state != null && (magnitude = TestIconMapper.getMagnitude((int)state.magnitude)) != null) {
            switch (magnitude) {
                case ERROR_INDEX: 
                case FAILED_INDEX: {
                    return AllIcons.RunConfigurations.TestState.Red2;
                }
                case PASSED_INDEX: 
                case COMPLETE_INDEX: {
                    return AllIcons.RunConfigurations.TestState.Green2;
                }
            }
        }
        return isClass ? AllIcons.RunConfigurations.TestState.Run_run : AllIcons.RunConfigurations.TestState.Run;
    }
}

