/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.popup.MovablePopup;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.MouseEventHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExpandableItemsHandler<KeyType, ComponentType extends JComponent>
implements ExpandableItemsHandler<KeyType> {
    protected final ComponentType myComponent;
    private final Alarm myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final CellRendererPane myRendererPane = new CellRendererPane();
    private final JComponent myTipComponent = new JComponent(){

        @Override
        protected void paintComponent(Graphics g) {
            Insets insets = this.getInsets();
            UIUtil.drawImage((Graphics)g, (Image)AbstractExpandableItemsHandler.this.myImage, (int)insets.left, (int)insets.top, null);
        }
    };
    private boolean myEnabled = Registry.is((String)"ide.expansion.hints.enabled");
    private final MovablePopup myPopup;
    private KeyType myKey;
    private Rectangle myKeyItemBounds;
    private BufferedImage myImage;

    public static void setRelativeBounds(@NotNull Component parent, @NotNull Rectangle bounds, @NotNull Component child, @NotNull Container validationParent) {
        validationParent.add(parent);
        parent.setBounds(bounds);
        parent.validate();
        child.setLocation(SwingUtilities.convertPoint(child, 0, 0, parent));
        validationParent.remove(parent);
    }

    protected AbstractExpandableItemsHandler(@NotNull ComponentType component) {
        this.myComponent = component;
        ((Container)this.myComponent).add(this.myRendererPane);
        ((Container)this.myComponent).validate();
        this.myPopup = new MovablePopup((Component)this.myComponent, this.myTipComponent);
        MouseEventHandler dispatcher = new MouseEventHandler(){

            protected void handle(MouseEvent event) {
                ((Component)AbstractExpandableItemsHandler.this.myComponent).dispatchEvent(MouseEventAdapter.convert((MouseEvent)event, AbstractExpandableItemsHandler.this.myComponent));
            }

            public void mouseEntered(MouseEvent event) {
            }

            public void mouseExited(MouseEvent event) {
                if (((Component)AbstractExpandableItemsHandler.this.myComponent).getMousePosition() == null) {
                    AbstractExpandableItemsHandler.this.hideHint();
                }
            }
        };
        this.myTipComponent.addMouseListener((MouseListener)dispatcher);
        this.myTipComponent.addMouseMotionListener((MouseMotionListener)dispatcher);
        this.myTipComponent.addMouseWheelListener((MouseWheelListener)dispatcher);
        MouseEventHandler handler2 = new MouseEventHandler(){

            protected void handle(MouseEvent event) {
                AbstractExpandableItemsHandler.this.handleMouseEvent(event, 503 != event.getID());
            }

            public void mouseClicked(MouseEvent event) {
            }

            public void mouseExited(MouseEvent event) {
                if (AbstractExpandableItemsHandler.this.myTipComponent.getMousePosition() == null) {
                    AbstractExpandableItemsHandler.this.hideHint();
                }
            }
        };
        ((Component)this.myComponent).addMouseListener((MouseListener)handler2);
        ((Component)this.myComponent).addMouseMotionListener((MouseMotionListener)handler2);
        ((Component)this.myComponent).addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractExpandableItemsHandler.this.onFocusLost();
            }

            @Override
            public void focusGained(FocusEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.updateCurrentSelection();
            }
        });
        ((Component)this.myComponent).addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                AbstractExpandableItemsHandler.this.hideHint();
            }
        });
    }

    protected void onFocusLost() {
        this.hideHint();
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
        if (!this.myEnabled) {
            this.hideHint();
        }
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    @NotNull
    public Collection<KeyType> getExpandedItems() {
        return this.myKey == null ? Collections.emptyList() : Collections.singleton(this.myKey);
    }

    protected void updateCurrentSelection() {
        this.handleSelectionChange(this.myKey, true);
    }

    protected void handleMouseEvent(MouseEvent e, boolean forceUpdate) {
        KeyType selected = this.getCellKeyForPoint(e.getPoint());
        if (forceUpdate || !Comparing.equal(this.myKey, selected)) {
            this.handleSelectionChange(selected, true);
        }
        if (e.getClickCount() == 2) {
            this.hideHint();
        }
    }

    protected void handleSelectionChange(KeyType selected) {
        this.handleSelectionChange(selected, false);
    }

    protected void handleSelectionChange(KeyType selected, boolean processIfUnfocused) {
        if (!EventQueue.isDispatchThread()) {
            return;
        }
        this.myUpdateAlarm.cancelAllRequests();
        if (selected == null || !this.isHandleSelectionEnabled(selected, processIfUnfocused)) {
            this.hideHint();
            return;
        }
        if (!selected.equals(this.myKey)) {
            this.hideHint();
        }
        this.myUpdateAlarm.addRequest(() -> this.doHandleSelectionChange(selected, processIfUnfocused), 10);
    }

    private boolean isHandleSelectionEnabled(@NotNull KeyType selected, boolean processIfUnfocused) {
        return this.myEnabled && ((Component)this.myComponent).isEnabled() && ((Component)this.myComponent).isShowing() && ((JComponent)this.myComponent).getVisibleRect().intersects(this.getVisibleRect(selected)) && (processIfUnfocused || ((Component)this.myComponent).isFocusOwner()) && !this.isPopup();
    }

    private void doHandleSelectionChange(@NotNull KeyType selected, boolean processIfUnfocused) {
        if (!this.isHandleSelectionEnabled(selected, processIfUnfocused)) {
            this.hideHint();
            return;
        }
        this.myKey = selected;
        Point location = this.createToolTipImage(this.myKey);
        if (location == null) {
            this.hideHint();
        } else {
            Rectangle bounds = new Rectangle(location, this.myTipComponent.getPreferredSize());
            this.myPopup.setBounds(bounds);
            this.myPopup.setVisible(this.noIntersections(bounds));
            this.repaintKeyItem();
        }
    }

    protected boolean isPopup() {
        Window window = SwingUtilities.getWindowAncestor(this.myComponent);
        return window != null && !(window instanceof Dialog) && !(window instanceof Frame) && !AbstractExpandableItemsHandler.isHintsAllowed(window);
    }

    private static boolean isHintsAllowed(Window window) {
        JRootPane pane;
        if (window instanceof RootPaneContainer && (pane = ((RootPaneContainer)((Object)window)).getRootPane()) != null) {
            return Boolean.TRUE.equals(pane.getClientProperty("ShowHints"));
        }
        return false;
    }

    private static boolean isFocused(Window window) {
        return window != null && (window.isFocused() || AbstractExpandableItemsHandler.isFocused(window.getOwner()));
    }

    private boolean noIntersections(Rectangle bounds) {
        Window owner = SwingUtilities.getWindowAncestor(this.myComponent);
        Window popup = SwingUtilities.getWindowAncestor(this.myTipComponent);
        Window focus = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (focus == owner.getOwner()) {
            focus = null;
        }
        boolean focused = SystemInfo.isWindows || AbstractExpandableItemsHandler.isFocused(owner);
        for (Window other : owner.getOwnedWindows()) {
            if (!focused) {
                focused = other.isFocused();
            }
            if (popup != other && other.isVisible() && bounds.x + 10 >= other.getX() && bounds.intersects(other.getBounds())) {
                return false;
            }
            if (focus != other) continue;
            focus = null;
        }
        return focused && (focus == owner || focus == null || !owner.getBounds().intersects(focus.getBounds()));
    }

    private void hideHint() {
        this.myUpdateAlarm.cancelAllRequests();
        if (this.myPopup.isVisible()) {
            this.myPopup.setVisible(false);
            this.repaintKeyItem();
        }
        this.myKey = null;
    }

    public boolean isShowing() {
        return this.myPopup.isVisible();
    }

    private void repaintKeyItem() {
        if (this.myKeyItemBounds != null) {
            ((JComponent)this.myComponent).repaint(this.myKeyItemBounds);
        }
    }

    @Nullable
    private Point createToolTipImage(@NotNull KeyType key2) {
        UIUtil.putClientProperty(this.myComponent, (Key)EXPANDED_RENDERER, (Object)true);
        Pair<Component, Rectangle> rendererAndBounds = this.getCellRendererAndBounds(key2);
        UIUtil.putClientProperty(this.myComponent, (Key)EXPANDED_RENDERER, null);
        if (rendererAndBounds == null) {
            return null;
        }
        JComponent renderer = (JComponent)ObjectUtils.tryCast((Object)rendererAndBounds.first, JComponent.class);
        if (renderer == null) {
            return null;
        }
        if (UIUtil.isClientPropertyTrue((Object)renderer, (Object)RENDERER_DISABLED)) {
            return null;
        }
        if (UIUtil.isClientPropertyTrue((Object)rendererAndBounds.getFirst(), (Object)USE_RENDERER_BOUNDS)) {
            ((Rectangle)rendererAndBounds.getSecond()).translate(renderer.getX(), renderer.getY());
            ((Rectangle)rendererAndBounds.getSecond()).setSize(renderer.getSize());
        }
        Rectangle cellBounds = this.myKeyItemBounds = (Rectangle)rendererAndBounds.second;
        Rectangle visibleRect = this.getVisibleRect(key2);
        if (cellBounds.y < visibleRect.y) {
            return null;
        }
        int cellMaxY = cellBounds.y + cellBounds.height;
        int visMaxY = visibleRect.y + visibleRect.height;
        if (cellMaxY > visMaxY) {
            return null;
        }
        int cellMaxX = cellBounds.x + cellBounds.width;
        int visMaxX = visibleRect.x + visibleRect.width;
        Point location = new Point(visMaxX, cellBounds.y);
        SwingUtilities.convertPointToScreen(location, this.myComponent);
        Rectangle screen = ScreenUtil.getScreenRectangle((Point)location);
        int borderWidth = this.isPaintBorder() ? 1 : 0;
        int width = Math.min(screen.width + screen.x - location.x - borderWidth, cellMaxX - visMaxX);
        int height = cellBounds.height;
        if (width <= 0 || height <= 0) {
            return null;
        }
        Dimension size = this.getImageSize(width, height);
        this.myImage = UIUtil.createImage(this.myComponent, (int)size.width, (int)size.height, (int)1);
        Graphics2D g = this.myImage.createGraphics();
        g.setClip(null);
        this.doFillBackground(height, width, g);
        g.translate(cellBounds.x - visMaxX, 0);
        this.doPaintTooltipImage(renderer, cellBounds, g, key2);
        CustomLineBorder border = null;
        if (borderWidth > 0) {
            border = new CustomLineBorder(this.getBorderColor(), borderWidth, 0, borderWidth, borderWidth);
            Insets insets = border.getBorderInsets((Component)this.myTipComponent);
            location.y -= insets.top;
            JBInsets.addTo((Dimension)size, (Insets)insets);
        }
        g.dispose();
        this.myRendererPane.remove(renderer);
        this.myTipComponent.setBorder((Border)border);
        this.myTipComponent.setPreferredSize(size);
        return location;
    }

    protected boolean isPaintBorder() {
        return true;
    }

    protected Color getBorderColor() {
        return JBColor.border();
    }

    protected Dimension getImageSize(int width, int height) {
        return new Dimension(width, height);
    }

    protected void doFillBackground(int height, int width, Graphics2D g) {
        g.setColor(((Component)this.myComponent).getBackground());
        g.fillRect(0, 0, width, height);
    }

    protected void doPaintTooltipImage(Component rComponent, Rectangle cellBounds, Graphics2D g, KeyType key2) {
        this.myRendererPane.paintComponent(g, rComponent, (Container)this.myComponent, 0, 0, cellBounds.width, cellBounds.height, true);
    }

    protected Rectangle getVisibleRect(KeyType key2) {
        return ((JComponent)this.myComponent).getVisibleRect();
    }

    @Nullable
    protected abstract Pair<Component, Rectangle> getCellRendererAndBounds(KeyType var1);

    protected abstract KeyType getCellKeyForPoint(Point var1);
}

