/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HideableDecorator {
    private final JPanel myPanel;
    private final TitledSeparator myTitledSeparator;
    private final boolean myAdjustWindow;
    private boolean myOn;
    private JComponent myContent;
    private Dimension myPreviousContentSize;

    public HideableDecorator(JPanel panel2, String title, boolean adjustWindow) {
        this(panel2, title, adjustWindow, null);
    }

    public HideableDecorator(JPanel panel2, String title, boolean adjustWindow, @Nullable JComponent northEastComponent) {
        this.myPanel = panel2;
        this.myAdjustWindow = adjustWindow;
        this.myTitledSeparator = new TitledSeparator(title, null){

            public void addNotify() {
                super.addNotify();
                HideableDecorator.this.registerMnemonic();
            }
        };
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.myTitledSeparator, "Center");
        if (northEastComponent != null) {
            northPanel.add((Component)northEastComponent, "East");
        }
        this.myPanel.add((Component)northPanel, "North");
        this.myTitledSeparator.setCursor(Cursor.getPredefinedCursor(12));
        this.updateIcon();
        this.myTitledSeparator.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (HideableDecorator.this.myOn) {
                    HideableDecorator.this.off();
                } else {
                    HideableDecorator.this.on();
                }
            }
        });
    }

    private void updateIcon() {
        Icon icon = this.myOn ? AllIcons.General.SplitDown : AllIcons.General.SplitRight;
        this.myTitledSeparator.getLabel().setIcon(icon);
        this.myTitledSeparator.getLabel().setDisabledIcon(IconLoader.getTransparentIcon((Icon)icon, (float)0.5f));
    }

    public void setContentComponent(@Nullable JComponent content) {
        if (content == null && this.myContent != null) {
            this.myPanel.remove(this.myContent);
        }
        this.myContent = content;
        if (this.myContent != null) {
            this.myContent.setVisible(this.myOn);
            this.myPanel.add((Component)this.myContent, "Center");
        }
    }

    public void setOn(boolean on) {
        this.myOn = on;
        if (this.myOn) {
            this.on();
        } else {
            this.off();
        }
    }

    public boolean isExpanded() {
        return this.myOn;
    }

    public void setTitle(String title) {
        this.myTitledSeparator.setText(title);
    }

    public String getTitle() {
        return this.myTitledSeparator.getText();
    }

    protected void on() {
        this.myOn = true;
        this.updateIcon();
        this.myTitledSeparator.getLabel().setIconTextGap(5);
        if (this.myContent != null) {
            this.myContent.setVisible(true);
        }
        this.adjustWindow();
        this.myPanel.invalidate();
        this.myPanel.repaint();
    }

    protected void off() {
        this.myOn = false;
        this.updateIcon();
        if (this.myContent != null) {
            this.myContent.setVisible(false);
            this.myPreviousContentSize = this.myContent.getSize();
        }
        this.adjustWindow();
        this.myPanel.invalidate();
        this.myPanel.repaint();
    }

    private void adjustWindow() {
        if (!this.myAdjustWindow) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this.myPanel);
        if (window == null) {
            return;
        }
        Dimension size = window.getSize();
        Dimension contentSize = this.myPreviousContentSize != null && this.myPreviousContentSize.width > 0 && this.myPreviousContentSize.height > 0 ? this.myPreviousContentSize : this.myContent.getPreferredSize();
        Dimension newSize = this.myOn ? new Dimension(Math.max(size.width, this.myContent.getSize().width), size.height + contentSize.height) : new Dimension(size.width, size.height - contentSize.height);
        if (!newSize.equals(size)) {
            SwingUtilities.invokeLater(() -> {
                if (window.isShowing()) {
                    window.setSize(newSize);
                }
            });
        }
    }

    public void setEnabled(boolean enabled) {
        this.myTitledSeparator.setEnabled(enabled);
        this.myContent.setEnabled(enabled);
    }

    private void registerMnemonic() {
        int mnemonicIndex = UIUtil.getDisplayMnemonicIndex((String)this.getTitle());
        if (mnemonicIndex != -1) {
            this.myPanel.getActionMap().put("Collapse/Expand on mnemonic", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (HideableDecorator.this.myOn) {
                        HideableDecorator.this.off();
                    } else {
                        HideableDecorator.this.on();
                    }
                }
            });
            Character mnemonicCharacter = Character.valueOf(UIUtil.removeMnemonic((String)this.getTitle()).toUpperCase().charAt(mnemonicIndex));
            this.myPanel.getInputMap(2).put(KeyStroke.getKeyStroke(mnemonicCharacter.charValue(), 8, false), "Collapse/Expand on mnemonic");
        }
    }
}

