/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.PseudoSplitter;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.ui.AbstractTitledSeparatorWithIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class SplitterWithSecondHideable {
    private final PseudoSplitter mySplitter;
    private final AbstractTitledSeparatorWithIcon myTitledSeparator;
    private final OnOffListener<Integer> myListener;
    private final JPanel myFictivePanel;
    private Splitter.DividerImpl mySuperDivider;
    private float myPreviousProportion;

    public SplitterWithSecondHideable(final boolean vertical, String separatorText, JComponent firstComponent, OnOffListener<Integer> listener2) {
        Icon openIcon;
        Icon icon;
        this.myListener = listener2;
        this.myFictivePanel = new JPanel(new BorderLayout());
        if (vertical) {
            icon = AllIcons.General.ComboArrowRight;
            openIcon = AllIcons.General.ComboArrowDown;
        } else {
            icon = AllIcons.General.ComboArrowRight;
            openIcon = AllIcons.General.ComboArrowRightPassive;
        }
        this.myTitledSeparator = new AbstractTitledSeparatorWithIcon(icon, openIcon, separatorText){

            @Override
            protected RefreshablePanel createPanel() {
                return SplitterWithSecondHideable.this.createDetails();
            }

            @Override
            protected void initOnImpl() {
                float proportion = SplitterWithSecondHideable.this.myPreviousProportion > 0.0f ? SplitterWithSecondHideable.this.myPreviousProportion : SplitterWithSecondHideable.this.getSplitterInitialProportion();
                SplitterWithSecondHideable.this.mySplitter.setSecondComponent((JComponent)this.myDetailsComponent.getPanel());
                SplitterWithSecondHideable.this.mySuperDivider.setResizeEnabled(true);
                SwingUtilities.invokeLater(() -> {
                    SplitterWithSecondHideable.this.mySplitter.fixFirst(proportion);
                    SplitterWithSecondHideable.this.mySplitter.invalidate();
                    SplitterWithSecondHideable.this.mySplitter.validate();
                    SplitterWithSecondHideable.this.mySplitter.repaint();
                });
            }

            @Override
            protected void onImpl() {
                float proportion = SplitterWithSecondHideable.this.myPreviousProportion > 0.0f ? SplitterWithSecondHideable.this.myPreviousProportion : SplitterWithSecondHideable.this.getSplitterInitialProportion();
                int firstSize = vertical ? SplitterWithSecondHideable.this.mySplitter.getFirstComponent().getHeight() : SplitterWithSecondHideable.this.mySplitter.getFirstComponent().getWidth();
                SplitterWithSecondHideable.this.mySplitter.fixFirst();
                SplitterWithSecondHideable.this.myListener.on((int)((1.0f - proportion) * (float)firstSize / proportion));
                SplitterWithSecondHideable.this.mySplitter.setSecondComponent((JComponent)this.myDetailsComponent.getPanel());
                SplitterWithSecondHideable.this.mySplitter.revalidate();
                SplitterWithSecondHideable.this.mySplitter.repaint();
                SplitterWithSecondHideable.this.mySuperDivider.setResizeEnabled(true);
            }

            @Override
            protected void offImpl() {
                int previousSize = vertical ? SplitterWithSecondHideable.this.mySplitter.getSecondComponent().getHeight() : SplitterWithSecondHideable.this.mySplitter.getSecondComponent().getWidth();
                SplitterWithSecondHideable.this.mySplitter.setSecondComponent((JComponent)SplitterWithSecondHideable.this.myFictivePanel);
                SplitterWithSecondHideable.this.myPreviousProportion = SplitterWithSecondHideable.this.mySplitter.getProportion();
                SplitterWithSecondHideable.this.mySplitter.freeAll();
                SplitterWithSecondHideable.this.mySplitter.setProportion(1.0f);
                SplitterWithSecondHideable.this.mySplitter.revalidate();
                SplitterWithSecondHideable.this.mySplitter.repaint();
                SplitterWithSecondHideable.this.myListener.off(previousSize);
                SplitterWithSecondHideable.this.mySuperDivider.setResizeEnabled(false);
            }
        };
        this.mySplitter = new PseudoSplitter(vertical){
            {
                super(x0);
                ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.setCursor(new Cursor(((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.myOn ? 9 : 0));
                        ((MyDivider)SplitterWithSecondHideable.this.mySuperDivider).processMouseEvent(e);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.setCursor(new Cursor(0));
                        ((MyDivider)SplitterWithSecondHideable.this.mySuperDivider).processMouseEvent(e);
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ((MyDivider)SplitterWithSecondHideable.this.mySuperDivider).processMouseEvent(e);
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        ((MyDivider)SplitterWithSecondHideable.this.mySuperDivider).processMouseEvent(e);
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        ((MyDivider)SplitterWithSecondHideable.this.mySuperDivider).processMouseEvent(e);
                    }

                    @Override
                    public void mouseWheelMoved(MouseWheelEvent e) {
                        ((MyDivider)SplitterWithSecondHideable.this.mySuperDivider).processMouseEvent(e);
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        ((MyDivider)SplitterWithSecondHideable.this.mySuperDivider).processMouseEvent(e);
                    }

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        ((MyDivider)SplitterWithSecondHideable.this.mySuperDivider).processMouseEvent(e);
                    }
                });
                ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.addMouseMotionListener(new MouseMotionListener(){

                    @Override
                    public void mouseDragged(MouseEvent e) {
                        ((MyDivider)SplitterWithSecondHideable.this.mySuperDivider).processMouseMotionEvent(e);
                    }

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        ((MyDivider)SplitterWithSecondHideable.this.mySuperDivider).processMouseMotionEvent(e);
                    }
                });
            }

            protected Divider createDivider() {
                SplitterWithSecondHideable.this.mySuperDivider = new MyDivider();
                SplitterWithSecondHideable.this.mySuperDivider.add((Component)SplitterWithSecondHideable.this.myTitledSeparator, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
                return SplitterWithSecondHideable.this.mySuperDivider;
            }

            public int getDividerWidth() {
                return vertical ? SplitterWithSecondHideable.this.myTitledSeparator.getHeight() : SplitterWithSecondHideable.this.myTitledSeparator.getWidth();
            }

            class MyDivider
            extends Splitter.DividerImpl {
                MyDivider() {
                    super((Splitter)this);
                }

                public void processMouseMotionEvent(MouseEvent e) {
                    super.processMouseMotionEvent(e);
                }

                public void processMouseEvent(MouseEvent e) {
                    super.processMouseEvent(e);
                }
            }
        };
        this.mySplitter.setDoubleBuffered(true);
        this.mySplitter.setFirstComponent(firstComponent);
        this.mySplitter.setSecondComponent((JComponent)this.myFictivePanel);
        this.mySplitter.setProportion(1.0f);
    }

    public void setText(String value2) {
        this.myTitledSeparator.setText(value2);
    }

    public Splitter getComponent() {
        return this.mySplitter;
    }

    protected abstract RefreshablePanel createDetails();

    protected abstract float getSplitterInitialProportion();

    public float getUsedProportion() {
        return this.isOn() ? this.mySplitter.getProportion() : this.myPreviousProportion;
    }

    public void initOn() {
        this.myTitledSeparator.initOn();
    }

    public void on() {
        this.myTitledSeparator.on();
    }

    public void off() {
        this.myTitledSeparator.off();
    }

    public boolean isOn() {
        return this.myTitledSeparator.myOn;
    }

    public static interface OnOffListener<T> {
        public void on(T var1);

        public void off(T var1);
    }
}

