/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;

public class TreeSpeedSearch
extends SpeedSearchBase<JTree> {
    private boolean myCanExpand;
    private static final Convertor<TreePath, String> TO_STRING = new Convertor<TreePath, String>(){

        public String convert(TreePath object) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object.getLastPathComponent();
            return node.toString();
        }
    };
    private final Convertor<TreePath, String> myToStringConvertor;
    public static final Convertor<TreePath, String> NODE_DESCRIPTOR_TOSTRING = new Convertor<TreePath, String>(){

        public String convert(TreePath path) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject instanceof NodeDescriptor) {
                NodeDescriptor descr = (NodeDescriptor)userObject;
                return descr.toString();
            }
            return (String)TO_STRING.convert((Object)path);
        }
    };

    public TreeSpeedSearch(JTree tree, Convertor<TreePath, String> toStringConvertor) {
        this(tree, toStringConvertor, false);
    }

    public TreeSpeedSearch(JTree tree) {
        this(tree, TO_STRING);
    }

    public TreeSpeedSearch(Tree tree, Convertor<TreePath, String> toString) {
        this(tree, toString, false);
    }

    public TreeSpeedSearch(Tree tree, Convertor<TreePath, String> toString, boolean canExpand) {
        this((JTree)tree, toString, canExpand);
    }

    public TreeSpeedSearch(JTree tree, Convertor<TreePath, String> toString, boolean canExpand) {
        super(tree);
        this.setComparator(new SpeedSearchComparator(false, true));
        this.myToStringConvertor = toString;
        this.myCanExpand = canExpand;
        new MySelectAllAction(tree, this).registerCustomShortcutSet(tree, null);
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        TreeUtil.selectPath((JTree)((JTree)this.myComponent), (TreePath)((TreePath)element));
    }

    @Override
    protected int getSelectedIndex() {
        if (this.myCanExpand) {
            return ArrayUtilRt.find((Object[])this.getAllElements(), (Object)((JTree)this.myComponent).getSelectionPath());
        }
        int[] selectionRows = ((JTree)this.myComponent).getSelectionRows();
        return selectionRows == null || selectionRows.length == 0 ? -1 : selectionRows[0];
    }

    @Override
    protected Object[] getAllElements() {
        Object root;
        if (this.myCanExpand && ((root = ((JTree)this.myComponent).getModel().getRoot()) instanceof DefaultMutableTreeNode || root instanceof PathAwareTreeNode)) {
            ArrayList paths = new ArrayList();
            TreeUtil.traverseDepth((TreeNode)((TreeNode)root), node -> {
                if (node instanceof DefaultMutableTreeNode) {
                    paths.add(new TreePath(((DefaultMutableTreeNode)node).getPath()));
                } else if (node instanceof PathAwareTreeNode) {
                    paths.add(((PathAwareTreeNode)node).getPath());
                }
                return true;
            });
            return paths.toArray(new TreePath[paths.size()]);
        }
        Object[] paths = new TreePath[((JTree)this.myComponent).getRowCount()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = ((JTree)this.myComponent).getPathForRow(i);
        }
        return paths;
    }

    @Override
    protected String getElementText(Object element) {
        TreePath path = (TreePath)element;
        String string = (String)this.myToStringConvertor.convert((Object)path);
        if (string == null) {
            return (String)TO_STRING.convert((Object)path);
        }
        return string;
    }

    @NotNull
    private List<TreePath> findAllFilteredElements(String s) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        String _s = s.trim();
        ListIterator<Object> it = this.getElementIterator(0);
        while (it.hasNext()) {
            Object element = it.next();
            if (!this.isMatchingElement(element, _s)) continue;
            paths.add((TreePath)element);
        }
        return paths;
    }

    private static class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JTree myTree;
        @NotNull
        private final TreeSpeedSearch mySearch;

        public MySelectAllAction(@NotNull JTree tree, @NotNull TreeSpeedSearch search) {
            this.myTree = tree;
            this.mySearch = search;
            this.copyShortcutFrom(ActionManager.getInstance().getAction("$SelectAll"));
            this.setEnabledInModalContext(true);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myTree.getSelectionModel().getSelectionMode() == 4);
        }

        public void actionPerformed(AnActionEvent e) {
            boolean alreadySelected;
            TreeSelectionModel sm = this.myTree.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            List filtered = this.mySearch.findAllFilteredElements(query);
            if (filtered.isEmpty()) {
                return;
            }
            boolean bl = alreadySelected = sm.getSelectionCount() == filtered.size() && ContainerUtil.and((Iterable)filtered, path -> sm.isPathSelected((TreePath)path));
            if (alreadySelected) {
                TreePath anchor = this.myTree.getAnchorSelectionPath();
                sm.setSelectionPath(anchor);
                this.myTree.setAnchorSelectionPath(anchor);
                this.mySearch.findAndSelectElement(query);
            } else {
                TreePath currentElement = (TreePath)this.mySearch.findElement(query);
                TreePath anchor = (TreePath)ObjectUtils.chooseNotNull((Object)currentElement, filtered.get(0));
                sm.setSelectionPaths((TreePath[])ArrayUtil.toObjectArray((Collection)filtered, TreePath.class));
                this.myTree.setAnchorSelectionPath(anchor);
            }
        }
    }

    public static interface PathAwareTreeNode
    extends TreeNode {
        public TreePath getPath();
    }
}

