/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentManagerImpl
implements ContentManager,
PropertyChangeListener,
Disposable.Parent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.content.impl.ContentManagerImpl");
    private ContentUI myUI;
    private final List<Content> myContents = new ArrayList<Content>();
    private final EventDispatcher<ContentManagerListener> myDispatcher = EventDispatcher.create(ContentManagerListener.class);
    private final List<Content> mySelection = new ArrayList<Content>();
    private final boolean myCanCloseContents;
    private MyNonOpaquePanel myComponent;
    private final Set<Content> myContentWithChangedComponent = new HashSet<Content>();
    private boolean myDisposed;
    private final Project myProject;
    private final List<DataProvider> dataProviders = new SmartList();
    private ArrayList<Content> mySelectionHistory = new ArrayList();

    public ContentManagerImpl(@NotNull ContentUI contentUI, boolean canCloseContents, @NotNull Project project2) {
        this.myProject = project2;
        this.myCanCloseContents = canCloseContents;
        this.myUI = contentUI;
        this.myUI.setManager((ContentManager)this);
        Disposer.register((Disposable)project2, (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)contentUI);
    }

    public boolean canCloseContents() {
        return this.myCanCloseContents;
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new MyNonOpaquePanel();
            NonOpaquePanel contentComponent = new NonOpaquePanel();
            contentComponent.setContent(this.myUI.getComponent());
            contentComponent.setFocusCycleRoot(true);
            contentComponent.setFocusCycleRoot(!ScreenReader.isActive());
            this.myComponent.add((Component)contentComponent, "Center");
        }
        return this.myComponent;
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        Content selected = this.getSelectedContent();
        if (selected == null) {
            return ActionCallback.DONE;
        }
        BusyObject busyObject = selected.getBusyObject();
        return busyObject != null ? busyObject.getReady(requestor) : ActionCallback.DONE;
    }

    public void addContent(@NotNull Content content, int order) {
        this.doAddContent(content, order);
    }

    public void addContent(@NotNull Content content) {
        this.doAddContent(content, -1);
    }

    public void addContent(@NotNull Content content, Object constraints) {
        this.doAddContent(content, -1);
    }

    private void doAddContent(@NotNull Content content, int index) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myContents.contains(content)) {
            this.myContents.remove(content);
            this.myContents.add(index == -1 ? this.myContents.size() : index, content);
            return;
        }
        ((ContentImpl)content).setManager(this);
        int insertIndex = index == -1 ? this.myContents.size() : index;
        this.myContents.add(insertIndex, content);
        content.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireContentAdded(content, insertIndex);
        if (this.myUI.isToSelectAddedContent() || this.mySelection.isEmpty() && !this.myUI.canBeEmptySelection()) {
            if (this.myUI.isSingleSelection()) {
                this.setSelectedContent(content);
            } else {
                this.addSelectedContent(content);
            }
        }
        Disposer.register((Disposable)this, (Disposable)content);
    }

    public boolean removeContent(@NotNull Content content, boolean dispose) {
        return this.removeContent(content, true, dispose).isDone();
    }

    @NotNull
    public ActionCallback removeContent(@NotNull Content content, boolean dispose, boolean trackFocus, boolean forcedFocus) {
        ActionCallback result2 = new ActionCallback();
        this.removeContent(content, true, dispose).doWhenDone(() -> {
            if (trackFocus) {
                Content current = this.getSelectedContent();
                if (current != null) {
                    this.setSelectedContent(current, true, true, !forcedFocus);
                } else {
                    result2.setDone();
                }
            } else {
                result2.setDone();
            }
        });
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ActionCallback removeContent(@NotNull Content content, boolean trackSelection, boolean dispose) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int indexToBeRemoved = this.getIndexOfContent(content);
        if (indexToBeRemoved == -1) {
            return ActionCallback.REJECTED;
        }
        try {
            int newSize;
            int selectedIndex;
            Content selection = this.mySelection.isEmpty() ? null : this.mySelection.get(this.mySelection.size() - 1);
            int n = selectedIndex = selection != null ? this.myContents.indexOf(selection) : -1;
            if (!this.fireContentRemoveQuery(content, indexToBeRemoved, ContentManagerEvent.ContentOperation.undefined)) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                return actionCallback;
            }
            if (!content.isValid()) {
                ActionCallback actionCallback = ActionCallback.REJECTED;
                return actionCallback;
            }
            boolean wasSelected = this.isSelected(content);
            if (wasSelected) {
                this.removeFromSelection(content);
            }
            int indexToSelect = -1;
            if (wasSelected) {
                int i = indexToBeRemoved - 1;
                if (i >= 0) {
                    indexToSelect = i;
                } else if (this.getContentCount() > 1) {
                    indexToSelect = 0;
                }
            } else if (selectedIndex > indexToBeRemoved) {
                indexToSelect = selectedIndex - 1;
            }
            this.mySelectionHistory.remove(content);
            this.myContents.remove(content);
            content.removePropertyChangeListener((PropertyChangeListener)this);
            this.fireContentRemoved(content, indexToBeRemoved);
            ((ContentImpl)content).setManager(null);
            if (dispose) {
                Disposer.dispose((Disposable)content);
            }
            if ((newSize = this.myContents.size()) > 0 && trackSelection) {
                ActionCallback result2 = new ActionCallback();
                if (indexToSelect > -1) {
                    Content toSelect;
                    Content content2 = toSelect = this.mySelectionHistory.size() > 0 ? this.mySelectionHistory.get(0) : this.myContents.get(indexToSelect);
                    if (!this.isSelected(toSelect)) {
                        if (this.myUI.isSingleSelection()) {
                            this.setSelectedContentCB(toSelect).notify(result2);
                        } else {
                            this.addSelectedContent(toSelect);
                            result2.setDone();
                        }
                    }
                }
                ActionCallback actionCallback = result2;
                return actionCallback;
            }
            this.mySelection.clear();
            ActionCallback actionCallback = ActionCallback.DONE;
            return actionCallback;
        }
        finally {
            if (ApplicationManager.getApplication().isDispatchThread() && !this.myDisposed) {
                this.myUI.getComponent().updateUI();
            }
        }
    }

    public void removeAllContents(boolean dispose) {
        Content[] contents;
        for (Content content : contents = this.getContents()) {
            this.removeContent(content, dispose);
        }
    }

    public int getContentCount() {
        return this.myContents.size();
    }

    @NotNull
    public Content[] getContents() {
        return this.myContents.toArray(new Content[this.myContents.size()]);
    }

    public Content findContent(String displayName) {
        for (Content content : this.myContents) {
            if (!content.getDisplayName().equals(displayName)) continue;
            return content;
        }
        return null;
    }

    public Content getContent(int index) {
        return index >= 0 && index < this.myContents.size() ? this.myContents.get(index) : null;
    }

    public Content getContent(JComponent component) {
        Content[] contents;
        for (Content content : contents = this.getContents()) {
            if (!Comparing.equal((Object)component, (Object)content.getComponent())) continue;
            return content;
        }
        return null;
    }

    public int getIndexOfContent(Content content) {
        return this.myContents.indexOf(content);
    }

    @NotNull
    public String getCloseActionName() {
        return this.myUI.getCloseActionName();
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        return this.myUI.getCloseAllButThisActionName();
    }

    @NotNull
    public String getPreviousContentActionName() {
        return this.myUI.getPreviousContentActionName();
    }

    @NotNull
    public String getNextContentActionName() {
        return this.myUI.getNextContentActionName();
    }

    public List<AnAction> getAdditionalPopupActions(@NotNull Content content) {
        return null;
    }

    public boolean canCloseAllContents() {
        if (!this.canCloseContents()) {
            return false;
        }
        for (Content content : this.myContents) {
            if (!content.isCloseable()) continue;
            return true;
        }
        return false;
    }

    public void addSelectedContent(@NotNull Content content) {
        if (!this.checkSelectionChangeShouldBeProcessed(content, false)) {
            return;
        }
        if (this.getIndexOfContent(content) == -1) {
            throw new IllegalArgumentException("content not found: " + content);
        }
        if (!this.isSelected(content)) {
            this.mySelection.add(content);
            this.fireSelectionChanged(content, ContentManagerEvent.ContentOperation.add);
        }
    }

    private boolean checkSelectionChangeShouldBeProcessed(Content content, boolean implicit) {
        if (!this.myUI.canChangeSelectionTo(content, implicit)) {
            return false;
        }
        boolean result2 = !this.isSelected(content) || this.myContentWithChangedComponent.contains(content);
        this.myContentWithChangedComponent.remove(content);
        return result2;
    }

    public void removeFromSelection(@NotNull Content content) {
        if (!this.isSelected(content)) {
            return;
        }
        this.mySelection.remove(content);
        this.fireSelectionChanged(content, ContentManagerEvent.ContentOperation.remove);
    }

    public boolean isSelected(@NotNull Content content) {
        return this.mySelection.contains(content);
    }

    @NotNull
    public Content[] getSelectedContents() {
        return this.mySelection.toArray(new Content[this.mySelection.size()]);
    }

    @Nullable
    public Content getSelectedContent() {
        return this.mySelection.isEmpty() ? null : this.mySelection.get(0);
    }

    public void setSelectedContent(@NotNull Content content, boolean requestFocus) {
        this.setSelectedContentCB(content, requestFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus) {
        return this.setSelectedContentCB(content, requestFocus, true);
    }

    public void setSelectedContent(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
        this.setSelectedContentCB(content, requestFocus, forcedFocus);
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content, boolean requestFocus, boolean forcedFocus) {
        return this.setSelectedContent(content, requestFocus, forcedFocus, false);
    }

    @NotNull
    public ActionCallback setSelectedContent(final @NotNull Content content, final boolean requestFocus, final boolean forcedFocus, boolean implicit) {
        this.mySelectionHistory.remove(content);
        this.mySelectionHistory.add(0, content);
        if (this.isSelected(content) && requestFocus) {
            return this.requestFocus(content, forcedFocus);
        }
        if (!this.checkSelectionChangeShouldBeProcessed(content, implicit)) {
            return ActionCallback.REJECTED;
        }
        if (!this.myContents.contains(content)) {
            throw new IllegalArgumentException("Cannot find content:" + content.getDisplayName());
        }
        boolean focused = this.isSelectionHoldsFocus();
        final Content[] old = this.getSelectedContents();
        ActiveRunnable selection = new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                if (ContentManagerImpl.this.myDisposed || ContentManagerImpl.this.getIndexOfContent(content) == -1) {
                    return ActionCallback.REJECTED;
                }
                for (Content each : old) {
                    ContentManagerImpl.this.removeFromSelection(each);
                }
                ContentManagerImpl.this.addSelectedContent(content);
                if (requestFocus) {
                    return ContentManagerImpl.this.requestFocus(content, forcedFocus);
                }
                return ActionCallback.DONE;
            }
        };
        ActionCallback result2 = new ActionCallback();
        boolean enabledFocus = this.getFocusManager().isFocusTransferEnabled();
        if (focused || requestFocus) {
            if (enabledFocus) {
                return this.getFocusManager().requestFocus((Component)((Object)this.myComponent), true).doWhenProcessed(() -> selection.run().notify(result2));
            }
            return selection.run().notify(result2);
        }
        return selection.run().notify(result2);
    }

    private boolean isSelectionHoldsFocus() {
        Content[] selection;
        boolean focused = false;
        for (Content each : selection = this.getSelectedContents()) {
            if (!UIUtil.isFocusAncestor((JComponent)each.getComponent())) continue;
            focused = true;
            break;
        }
        return focused;
    }

    @NotNull
    public ActionCallback setSelectedContentCB(@NotNull Content content) {
        return this.setSelectedContentCB(content, false);
    }

    public void setSelectedContent(@NotNull Content content) {
        this.setSelectedContentCB(content);
    }

    public ActionCallback selectPreviousContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index - 1 + contentCount) % contentCount;
        Content content = this.getContent(index);
        if (content == null) {
            return null;
        }
        return this.setSelectedContentCB(content, true);
    }

    public ActionCallback selectNextContent() {
        int contentCount = this.getContentCount();
        LOG.assertTrue(contentCount > 1);
        Content selectedContent = this.getSelectedContent();
        int index = this.getIndexOfContent(selectedContent);
        index = (index + 1) % contentCount;
        Content content = this.getContent(index);
        if (content == null) {
            return null;
        }
        return this.setSelectedContentCB(content, true);
    }

    public void addContentManagerListener(@NotNull ContentManagerListener l) {
        this.myDispatcher.getListeners().add(0, l);
    }

    public void removeContentManagerListener(@NotNull ContentManagerListener l) {
        this.myDispatcher.removeListener((EventListener)l);
    }

    private void fireContentAdded(@NotNull Content content, int newIndex) {
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content, newIndex, ContentManagerEvent.ContentOperation.add);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentAdded(e);
    }

    private void fireContentRemoved(@NotNull Content content, int oldIndex) {
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content, oldIndex, ContentManagerEvent.ContentOperation.remove);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).contentRemoved(e);
    }

    private void fireSelectionChanged(@NotNull Content content, ContentManagerEvent.ContentOperation operation) {
        ContentManagerEvent e = new ContentManagerEvent((Object)this, content, this.getIndexOfContent(content), operation);
        ((ContentManagerListener)this.myDispatcher.getMulticaster()).selectionChanged(e);
    }

    private boolean fireContentRemoveQuery(@NotNull Content content, int oldIndex, ContentManagerEvent.ContentOperation operation) {
        ContentManagerEvent event = new ContentManagerEvent((Object)this, content, oldIndex, operation);
        for (ContentManagerListener listener2 : this.myDispatcher.getListeners()) {
            listener2.contentRemoveQuery(event);
            if (!event.isConsumed()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ActionCallback requestFocus(Content content, boolean forced) {
        Content toSelect;
        Content content2 = toSelect = content == null ? this.getSelectedContent() : content;
        if (toSelect == null) {
            return ActionCallback.REJECTED;
        }
        assert (this.myContents.contains(toSelect));
        return this.getFocusManager().requestFocus(new FocusCommand(content, toSelect.getPreferredFocusableComponent()){

            @NotNull
            public ActionCallback run() {
                return ContentManagerImpl.doRequestFocus(toSelect);
            }
        }, forced);
    }

    private IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    private static ActionCallback doRequestFocus(Content toSelect) {
        JComponent toFocus = ContentManagerImpl.computeWillFocusComponent(toSelect);
        if (toFocus != null) {
            toFocus.requestFocus();
        }
        return ActionCallback.DONE;
    }

    private static JComponent computeWillFocusComponent(Content toSelect) {
        JComponent toFocus = toSelect.getPreferredFocusableComponent();
        if (toFocus != null) {
            toFocus = IdeFocusTraversalPolicy.getPreferredFocusedComponent(toFocus);
        }
        if (toFocus == null) {
            toFocus = toSelect.getPreferredFocusableComponent();
        }
        return toFocus;
    }

    public void addDataProvider(@NotNull DataProvider provider2) {
        this.dataProviders.add(provider2);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        if ("component".equals(event.getPropertyName())) {
            this.myContentWithChangedComponent.add((Content)event.getSource());
        }
    }

    @NotNull
    public ContentFactory getFactory() {
        return (ContentFactory)ServiceManager.getService(ContentFactory.class);
    }

    public void beforeTreeDispose() {
        this.myUI.beforeDispose();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myContents.clear();
        this.mySelection.clear();
        this.myContentWithChangedComponent.clear();
        this.myUI = null;
        this.myDispatcher.getListeners().clear();
        this.dataProviders.clear();
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public boolean isSingleSelection() {
        return this.myUI.isSingleSelection();
    }

    private class MyNonOpaquePanel
    extends NonOpaquePanel
    implements DataProvider {
        public MyNonOpaquePanel() {
            super((LayoutManager)new BorderLayout());
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (PlatformDataKeys.CONTENT_MANAGER.is(dataId) || PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && ContentManagerImpl.this.getContentCount() > 1) {
                return ContentManagerImpl.this;
            }
            for (DataProvider dataProvider : ContentManagerImpl.this.dataProviders) {
                Object data = dataProvider.getData(dataId);
                if (data == null) continue;
                return data;
            }
            if (ContentManagerImpl.this.myUI instanceof DataProvider) {
                return ((DataProvider)ContentManagerImpl.this.myUI).getData(dataId);
            }
            DataProvider provider2 = DataManager.getDataProvider((JComponent)((Object)this));
            return provider2 == null ? null : provider2.getData(dataId);
        }
    }
}

