/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.ui.OwnerOptional;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class MacFileSaverDialog
implements FileSaverDialog {
    private FileDialog myFileDialog;
    private FileSaverDescriptor myDescriptor;

    private static String getChooserTitle(FileChooserDescriptor descriptor) {
        String title = descriptor.getTitle();
        return title != null ? title : UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    }

    public MacFileSaverDialog(FileSaverDescriptor descriptor, Project project2) {
        this(descriptor, IdeFocusManager.getInstance((Project)project2).getFocusOwner());
    }

    public MacFileSaverDialog(FileSaverDescriptor descriptor, Component parent) {
        String title = MacFileSaverDialog.getChooserTitle((FileChooserDescriptor)descriptor);
        Consumer dialogConsumer = owner -> {
            this.myFileDialog = new FileDialog((Dialog)owner, title, 1);
        };
        Consumer frameConsumer = owner -> {
            this.myFileDialog = new FileDialog((Frame)owner, title, 1);
        };
        this.myDescriptor = descriptor;
        OwnerOptional.fromComponent(parent).ifDialog((Consumer<Dialog>)dialogConsumer).ifFrame((Consumer<Frame>)frameConsumer).ifNull((Consumer<Frame>)frameConsumer);
    }

    @Nullable
    public VirtualFileWrapper save(@Nullable VirtualFile baseDir, @Nullable String filename) {
        this.myFileDialog.setDirectory(baseDir == null ? null : baseDir.getCanonicalPath());
        this.myFileDialog.setFile(filename);
        this.myFileDialog.setFilenameFilter((dir, name) -> {
            File file2 = new File(dir, name);
            return this.myDescriptor.isFileSelectable(MacFileSaverDialog.fileToVirtualFile(file2));
        });
        this.myFileDialog.setVisible(true);
        String file2 = this.myFileDialog.getFile();
        if (file2 == null) {
            return null;
        }
        return new VirtualFileWrapper(new File(this.myFileDialog.getDirectory() + File.separator + file2));
    }

    private static VirtualFile fileToVirtualFile(File file2) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        String vfsPath = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
        return localFileSystem.refreshAndFindFileByPath(vfsPath);
    }
}

