/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.fileChooser.impl.FileChooserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.OwnerOptional;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacPathChooserDialog
implements PathChooserDialog,
FileChooserDialog {
    private FileDialog myFileDialog;
    private final FileChooserDescriptor myFileChooserDescriptor;
    private final WeakReference<Component> myParent;
    private final Project myProject;
    private final String myTitle;
    private VirtualFile[] virtualFiles;

    public MacPathChooserDialog(FileChooserDescriptor descriptor, Component parent, Project project2) {
        this.myFileChooserDescriptor = descriptor;
        this.myParent = new WeakReference<Component>(parent);
        this.myProject = project2;
        this.myTitle = MacPathChooserDialog.getChooserTitle(descriptor);
        Consumer dialogConsumer = owner -> {
            this.myFileDialog = new FileDialog((Dialog)owner, this.myTitle, 0);
        };
        Consumer frameConsumer = owner -> {
            this.myFileDialog = new FileDialog((Frame)owner, this.myTitle, 0);
        };
        OwnerOptional.fromComponent(parent).ifDialog((Consumer<Dialog>)dialogConsumer).ifFrame((Consumer<Frame>)frameConsumer).ifNull((Consumer<Frame>)frameConsumer);
    }

    private static String getChooserTitle(FileChooserDescriptor descriptor) {
        String title = descriptor.getTitle();
        return title != null ? title : UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    }

    @NotNull
    private List<VirtualFile> getChosenFiles(Stream<File> streamOfFiles) {
        ArrayList<VirtualFile> virtualFiles = new ArrayList<VirtualFile>();
        streamOfFiles.forEach(file2 -> {
            VirtualFile virtualFile = this.fileToVirtualFile((File)file2);
            if (virtualFile != null && virtualFile.isValid()) {
                virtualFiles.add(virtualFile);
            }
        });
        return FileChooserUtil.getChosenFiles(this.myFileChooserDescriptor, virtualFiles);
    }

    private VirtualFile fileToVirtualFile(File file2) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        String vfsPath = FileUtil.toSystemIndependentName((String)file2.getAbsolutePath());
        return localFileSystem.refreshAndFindFileByPath(vfsPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void choose(@Nullable VirtualFile toSelect, @NotNull Consumer<List<VirtualFile>> callback) {
        boolean appStarted;
        if (toSelect != null && toSelect.getParent() != null) {
            String directoryName;
            String fileName = null;
            if (toSelect.isDirectory()) {
                directoryName = toSelect.getCanonicalPath();
            } else {
                directoryName = toSelect.getParent().getCanonicalPath();
                fileName = toSelect.getPath();
            }
            this.myFileDialog.setDirectory(directoryName);
            this.myFileDialog.setFile(fileName);
        }
        this.myFileDialog.setFilenameFilter((dir, name) -> {
            File file2 = new File(dir, name);
            return this.myFileChooserDescriptor.isFileSelectable(this.fileToVirtualFile(file2));
        });
        this.myFileDialog.setMultipleMode(this.myFileChooserDescriptor.isChooseMultiple());
        CommandProcessorEx commandProcessor = ApplicationManager.getApplication() != null ? (CommandProcessorEx)CommandProcessor.getInstance() : null;
        boolean bl = appStarted = commandProcessor != null;
        if (appStarted) {
            commandProcessor.enterModal();
            LaterInvocator.enterModal(this.myFileDialog);
        }
        Component parent = (Component)this.myParent.get();
        try {
            this.myFileDialog.setVisible(true);
        }
        finally {
            if (appStarted) {
                commandProcessor.leaveModal();
                LaterInvocator.leaveModal(this.myFileDialog);
                if (parent != null) {
                    parent.requestFocus();
                }
            }
        }
        Object[] files = this.myFileDialog.getFiles();
        List<VirtualFile> virtualFileList = this.getChosenFiles(Stream.of(files));
        this.virtualFiles = virtualFileList.toArray(VirtualFile.EMPTY_ARRAY);
        if (!virtualFileList.isEmpty()) {
            try {
                if (virtualFileList.size() == 1) {
                    this.myFileChooserDescriptor.isFileSelectable(virtualFileList.get(0));
                }
                this.myFileChooserDescriptor.validateSelectedFiles(this.virtualFiles);
            }
            catch (Exception e) {
                if (parent == null) {
                    Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)this.myTitle);
                } else {
                    Messages.showErrorDialog((Component)parent, (String)e.getMessage(), (String)this.myTitle);
                }
                return;
            }
            if (!ArrayUtil.isEmpty((Object[])files)) {
                callback.consume(virtualFileList);
                return;
            }
        }
        if (callback instanceof FileChooser.FileChooserConsumer) {
            ((FileChooser.FileChooserConsumer)callback).cancelled();
        }
    }

    @NotNull
    private static FileDialog createFileDialogWithoutOwner(String title, int load2) {
        return new FileDialog((Frame)null, title, load2);
    }

    @NotNull
    public VirtualFile[] choose(@Nullable VirtualFile toSelect, @Nullable Project project2) {
        this.choose(toSelect, (Consumer<List<VirtualFile>>)((Consumer)files -> {}));
        return this.virtualFiles;
    }

    @NotNull
    public VirtualFile[] choose(@Nullable Project project2, VirtualFile ... toSelect) {
        return this.choose(toSelect.length > 0 ? toSelect[0] : null, project2);
    }
}

