/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.plaf.gtk;

import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.ui.plaf.gtk.GtkPaintingUtil;
import com.intellij.ui.plaf.gtk.IconWrapper;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthMenuItemUI;

public class GtkMenuItemUI
extends BasicMenuItemUI {
    private static Icon myCachedCheckIcon = null;
    private final SynthMenuItemUI myOriginalUI;
    private JCheckBoxMenuItem myHiddenItem;

    public GtkMenuItemUI(SynthMenuItemUI originalUI) {
        this.myOriginalUI = originalUI;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.myHiddenItem = new JCheckBoxMenuItem();
        this.myOriginalUI.installUI(this.myHiddenItem);
        this.menuItem.setBorder(this.myHiddenItem.getBorder());
        Icon icon = GtkMenuItemUI.getCheckIconFromContext(this.myOriginalUI, this.myHiddenItem);
        this.checkIcon = this.isCheckBoxItem() ? icon : EmptyIcon.create((Icon)icon);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.myOriginalUI.uninstallUI(this.myHiddenItem);
        this.myHiddenItem = null;
        GtkMenuItemUI.resetCachedCheckIcon();
    }

    private static Icon getCheckIconFromContext(SynthMenuItemUI ui, JCheckBoxMenuItem item) {
        if (myCachedCheckIcon == null) {
            SynthContext context = ui.getContext(item);
            myCachedCheckIcon = context.getStyle().getIcon(context, "CheckBoxMenuItem.checkIcon");
        }
        return myCachedCheckIcon;
    }

    private boolean isCheckBoxItem() {
        return this.menuItem instanceof ActionMenuItem && ((ActionMenuItem)((Object)this.menuItem)).isToggleable();
    }

    private static void resetCachedCheckIcon() {
        myCachedCheckIcon = null;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        this.myHiddenItem.setSelected(this.menuItem.isSelected());
        if (UIUtil.isMurrineBasedTheme()) {
            this.acceleratorFont = this.menuItem.getFont();
            SynthContext context = this.myOriginalUI.getContext(this.menuItem);
            Color fg = context.getStyle().getColor(context, ColorType.TEXT_FOREGROUND);
            this.acceleratorForeground = UIUtil.mix((Color)fg, (Color)this.menuItem.getBackground(), (double)(this.menuItem.isSelected() ? 0.4 : 0.2));
            this.disabledForeground = fg;
        }
        if (this.checkIcon != null && !(this.checkIcon instanceof IconWrapper) && !(this.checkIcon instanceof EmptyIcon)) {
            this.checkIcon = new IconWrapper(this.checkIcon, this.myOriginalUI);
        }
        super.update(g, c);
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        if (!menuItem.isEnabled() && UIUtil.isMurrineBasedTheme()) {
            GtkPaintingUtil.paintDisabledText(this.myOriginalUI, g, menuItem, textRect, text);
        } else {
            super.paintText(g, menuItem, textRect, text);
        }
    }
}

