/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.util.ReflectionUtil;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayDeque;
import javax.swing.JWindow;

final class HeavyWeightPopupCache
implements ComponentListener {
    private final ArrayDeque<Window> myWindows = new ArrayDeque();

    HeavyWeightPopupCache() {
    }

    public static Window create(Window owner) {
        Window popup;
        HeavyWeightPopupCache cache2;
        if (owner != null && (cache2 = HeavyWeightPopupCache.getCache(owner)) != null && (popup = cache2.poll()) != null) {
            return popup;
        }
        JWindow popup2 = new JWindow(owner);
        popup2.setType(Window.Type.POPUP);
        return popup2;
    }

    public static void dispose(Window popup) {
        if (popup != null) {
            HeavyWeightPopupCache.hide(popup);
            Window owner = popup.getOwner();
            if (owner == null || !owner.isDisplayable()) {
                popup.dispose();
            } else {
                HeavyWeightPopupCache cache2 = HeavyWeightPopupCache.getCache(owner);
                if (cache2 == null) {
                    cache2 = new HeavyWeightPopupCache();
                    owner.addComponentListener(cache2);
                }
                cache2.push(popup);
            }
        }
    }

    private static HeavyWeightPopupCache getCache(Window owner) {
        for (ComponentListener listener2 : owner.getComponentListeners()) {
            if (!(listener2 instanceof HeavyWeightPopupCache)) continue;
            return (HeavyWeightPopupCache)listener2;
        }
        return null;
    }

    private static Window poll(ArrayDeque<Window> windows) {
        return windows.poll();
    }

    private static void push(ArrayDeque<Window> windows, Window popup) {
        windows.push(popup);
    }

    private static void hide(ArrayDeque<Window> windows) {
        for (Window window : windows) {
            HeavyWeightPopupCache.hide(window);
        }
    }

    private static void hide(Window window) {
        ReflectionUtil.setField(Window.class, (Object)window, Boolean.TYPE, (String)"showWithParent", (Object)false);
    }

    private Window poll() {
        return HeavyWeightPopupCache.poll(this.myWindows);
    }

    private void push(Window popup) {
        HeavyWeightPopupCache.push(this.myWindows, popup);
    }

    private void hide() {
        HeavyWeightPopupCache.hide(this.myWindows);
    }

    @Override
    public void componentResized(ComponentEvent event) {
    }

    @Override
    public void componentMoved(ComponentEvent event) {
    }

    @Override
    public void componentShown(ComponentEvent event) {
    }

    @Override
    public void componentHidden(ComponentEvent event) {
        HeavyWeightPopupCache cache2;
        Object source = event.getSource();
        if (source instanceof Window && (cache2 = HeavyWeightPopupCache.getCache((Window)source)) != null) {
            cache2.hide();
        }
    }
}

