/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ColorUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileColorConfiguration
implements Cloneable {
    private static final String COLOR = "color";
    private static final String SCOPE_NAME = "scope";
    private String myScopeName;
    private String myColorName;

    public FileColorConfiguration() {
    }

    public FileColorConfiguration(String scopeName, String colorName) {
        this.myScopeName = scopeName;
        this.myColorName = colorName;
    }

    public String getScopeName() {
        return this.myScopeName;
    }

    public void setScopeName(String scopeName) {
        this.myScopeName = scopeName;
    }

    public String getColorName() {
        return this.myColorName;
    }

    public String getColorPresentableName() {
        return ColorUtil.fromHex((String)this.myColorName, null) == null ? this.myColorName : "Custom";
    }

    public void setColorName(String colorName) {
        this.myColorName = colorName;
    }

    public boolean isValid(Project project2) {
        if (StringUtil.isEmpty((String)this.myScopeName) || this.myColorName == null) {
            return false;
        }
        return project2 == null || NamedScopesHolder.getScope((Project)project2, (String)this.myScopeName) != null;
    }

    public void save(@NotNull Element e) {
        if (!this.isValid(null)) {
            return;
        }
        Element tab = new Element("fileColor");
        tab.setAttribute(SCOPE_NAME, this.getScopeName());
        tab.setAttribute(COLOR, this.myColorName);
        e.addContent(tab);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileColorConfiguration that = (FileColorConfiguration)o;
        if (!this.myColorName.equals(that.myColorName)) {
            return false;
        }
        return this.myScopeName.equals(that.myScopeName);
    }

    public int hashCode() {
        int result2 = this.myScopeName.hashCode();
        result2 = 31 * result2 + this.myColorName.hashCode();
        return result2;
    }

    public FileColorConfiguration clone() throws CloneNotSupportedException {
        FileColorConfiguration result2 = new FileColorConfiguration();
        result2.myColorName = this.myColorName;
        result2.myScopeName = this.myScopeName;
        return result2;
    }

    @Nullable
    public static FileColorConfiguration load(@NotNull Element e) {
        String path = e.getAttributeValue(SCOPE_NAME);
        if (path == null) {
            return null;
        }
        String colorName = e.getAttributeValue(COLOR);
        if (colorName == null) {
            return null;
        }
        return new FileColorConfiguration(path, colorName);
    }
}

