/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ui.FileColorManager;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorConfigurationEditDialog;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public abstract class FileColorSettingsTable
extends JBTable {
    private static final int NAME_COLUMN = 0;
    private static final int COLOR_COLUMN = 1;
    private final List<FileColorConfiguration> myOriginal;
    @NotNull
    private final FileColorManager myManager;

    public FileColorSettingsTable(@NotNull FileColorManager manager, @NotNull List<FileColorConfiguration> configurations) {
        super((TableModel)new ModelAdapter(manager, FileColorSettingsTable.copy(configurations)));
        this.myManager = manager;
        this.setStriped(true);
        this.myOriginal = configurations;
        this.setAutoResizeMode(3);
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setCellRenderer(new ScopeNameRenderer());
        TableColumn colorColumn = columnModel.getColumn(1);
        colorColumn.setCellRenderer(new ColorCellRenderer(manager));
    }

    private static List<FileColorConfiguration> copy(@NotNull List<FileColorConfiguration> configurations) {
        ArrayList<FileColorConfiguration> result2 = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration c : configurations) {
            try {
                result2.add(c.clone());
            }
            catch (CloneNotSupportedException e) {
                assert (false) : "Should not happen!";
            }
        }
        return result2;
    }

    protected abstract void apply(@NotNull List<FileColorConfiguration> var1);

    public ModelAdapter getModel() {
        return (ModelAdapter)super.getModel();
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        if (e == null || e instanceof MouseEvent && ((MouseEvent)e).getClickCount() == 1) {
            return false;
        }
        Object at = this.getModel().getValueAt(row, column);
        if (!(at instanceof FileColorConfiguration)) {
            return false;
        }
        FileColorConfigurationEditDialog dialog2 = new FileColorConfigurationEditDialog(this.myManager, (FileColorConfiguration)at);
        dialog2.getScopeComboBox().setEnabled(false);
        dialog2.show();
        return false;
    }

    public boolean isModified() {
        List<FileColorConfiguration> current = this.getModel().getConfigurations();
        if (this.myOriginal.size() != current.size()) {
            return true;
        }
        for (int i2 = 0; i2 < current.size(); ++i2) {
            if (this.myOriginal.get(i2).equals(current.get(i2))) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.getModel().setConfigurations(this.myOriginal);
    }

    public void performRemove() {
        int rowCount = this.getSelectedRowCount();
        if (rowCount > 0) {
            int[] rows = this.getSelectedRows();
            for (int i2 = rows.length - 1; i2 >= 0; --i2) {
                this.removeConfiguration(rows[i2]);
            }
        }
    }

    public void moveUp() {
        int index;
        int rowCount = this.getSelectedRowCount();
        if (rowCount == 1 && (index = this.getModel().moveUp(this.getSelectedRows()[0])) > -1) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void moveDown() {
        int index;
        int rowCount = this.getSelectedRowCount();
        if (rowCount == 1 && (index = this.getModel().moveDown(this.getSelectedRows()[0])) > -1) {
            this.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void apply() {
        if (this.isModified()) {
            this.apply(this.getModel().getConfigurations());
        }
    }

    public FileColorConfiguration removeConfiguration(int index) {
        FileColorConfiguration removed = this.getModel().remove(index);
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            if (index > rowCount - 1) {
                this.getSelectionModel().setSelectionInterval(rowCount - 1, rowCount - 1);
            } else {
                this.getSelectionModel().setSelectionInterval(index, index);
            }
        }
        return removed;
    }

    public void addConfiguration(@NotNull FileColorConfiguration configuration) {
        this.getModel().add(configuration);
    }

    private static class ColorCellRenderer
    extends ScopeNameRenderer {
        private final FileColorManager myManager;

        private ColorCellRenderer(FileColorManager manager) {
            this.myManager = manager;
        }

        @Override
        Icon getIcon(FileColorConfiguration configuration) {
            Color color = this.myManager.getColor(configuration.getColorName());
            return color == null ? EmptyIcon.ICON_16 : JBUI.scale((JBUI.JBIcon)new ColorIcon(16, 13, color, true));
        }

        @Override
        String getText(FileColorConfiguration configuration) {
            return configuration.getColorPresentableName();
        }
    }

    private static class ScopeNameRenderer
    extends DefaultTableCellRenderer {
        private ScopeNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, value2, isSelected, false, row, column);
        }

        @Override
        protected void setValue(Object value2) {
            Icon icon = null;
            String text = null;
            if (value2 instanceof FileColorConfiguration) {
                icon = this.getIcon((FileColorConfiguration)value2);
                text = this.getText((FileColorConfiguration)value2);
            }
            this.setIcon(icon);
            this.setText(text == null ? "" : FileColorManagerImpl.getAlias(text));
        }

        Icon getIcon(FileColorConfiguration configuration) {
            return null;
        }

        String getText(FileColorConfiguration configuration) {
            return configuration.getScopeName();
        }
    }

    private static class ModelAdapter
    extends AbstractTableModel
    implements EditableModel {
        private final FileColorManager myManager;
        private List<FileColorConfiguration> myConfigurations;

        private ModelAdapter(FileColorManager manager, List<FileColorConfiguration> configurations) {
            this.myManager = manager;
            this.myConfigurations = configurations;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? "Scope" : "Color";
        }

        @Override
        public int getRowCount() {
            return this.myConfigurations.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return 0 <= rowIndex && rowIndex < this.myConfigurations.size() ? this.myConfigurations.get(rowIndex) : null;
        }

        @NotNull
        public List<FileColorConfiguration> getConfigurations() {
            return this.myConfigurations;
        }

        public FileColorConfiguration remove(int index) {
            FileColorConfiguration removed = this.myConfigurations.remove(index);
            this.fireTableRowsDeleted(index, index);
            return removed;
        }

        public void add(@NotNull FileColorConfiguration configuration) {
            this.myConfigurations.add(configuration);
            this.fireTableRowsInserted(this.myConfigurations.size() - 1, this.myConfigurations.size() - 1);
        }

        public void setConfigurations(List<FileColorConfiguration> original) {
            this.myConfigurations = FileColorSettingsTable.copy(original);
            this.fireTableDataChanged();
        }

        public int moveUp(int index) {
            if (index > 0) {
                FileColorConfiguration configuration = this.myConfigurations.get(index);
                this.myConfigurations.remove(index);
                this.myConfigurations.add(index - 1, configuration);
                this.fireTableRowsUpdated(index - 1, index);
                return index - 1;
            }
            return -1;
        }

        public int moveDown(int index) {
            if (index < this.getRowCount() - 1) {
                FileColorConfiguration configuration = this.myConfigurations.get(index);
                this.myConfigurations.remove(index);
                this.myConfigurations.add(index + 1, configuration);
                this.fireTableRowsUpdated(index, index + 1);
                return index + 1;
            }
            return -1;
        }

        public void addRow() {
            FileColorConfigurationEditDialog dialog2 = new FileColorConfigurationEditDialog(this.myManager, null);
            dialog2.show();
            if (dialog2.getExitCode() == 0) {
                this.myConfigurations.add(dialog2.getConfiguration());
                int i2 = this.myConfigurations.size() - 1;
                this.fireTableRowsInserted(i2, i2);
            }
        }

        public void removeRow(int index) {
            this.myConfigurations.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            this.myConfigurations.add(newIndex, this.myConfigurations.remove(oldIndex));
            this.fireTableRowsUpdated(Math.min(oldIndex, newIndex), Math.max(oldIndex, newIndex));
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }
    }
}

