/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MethodGroupingRule
implements UsageGroupingRule {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usages.impl.rules.MethodGroupingRule");

    public UsageGroup groupUsage(@NotNull Usage usage) {
        if (!(usage instanceof PsiElementUsage)) {
            return null;
        }
        PsiElement psiElement = ((PsiElementUsage)usage).getElement();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
        PsiFile topLevelFile = manager.getTopLevelFile((PsiElement)containingFile);
        if (topLevelFile instanceof PsiJavaFile) {
            PsiClass containingClass;
            PsiElement containingMethod;
            Object object = containingMethod = topLevelFile == containingFile ? psiElement : manager.getInjectionHost((PsiElement)containingFile);
            if (usage instanceof UsageInfo2UsageAdapter && topLevelFile == containingFile) {
                int offset = ((UsageInfo2UsageAdapter)usage).getUsageInfo().getNavigationOffset();
                containingMethod = containingFile.findElementAt(offset);
            }
            while ((containingMethod = PsiTreeUtil.getParentOfType((PsiElement)containingMethod, PsiMethod.class, (boolean)true)) != null && (containingClass = ((PsiMethod)containingMethod).getContainingClass()) != null && containingClass.getQualifiedName() == null) {
            }
            if (containingMethod != null) {
                return new MethodUsageGroup((PsiMethod)containingMethod);
            }
        }
        return null;
    }

    private static class MethodUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final SmartPsiElementPointer<PsiMethod> myMethodPointer;
        private final String myName;
        private final Icon myIcon;
        private final Project myProject;

        public MethodUsageGroup(PsiMethod psiMethod) {
            this.myName = PsiFormatUtil.formatMethod((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            this.myProject = psiMethod.getProject();
            this.myMethodPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)psiMethod);
            this.myIcon = MethodUsageGroup.getIconImpl(psiMethod);
        }

        public void update() {
        }

        private static Icon getIconImpl(PsiMethod psiMethod) {
            return psiMethod.getIcon(3);
        }

        public int hashCode() {
            return this.myName.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodUsageGroup)) {
                return false;
            }
            MethodUsageGroup group = (MethodUsageGroup)object;
            return Comparing.equal((String)this.myName, (String)((MethodUsageGroup)object).myName) && SmartPointerManager.getInstance((Project)this.myProject).pointToTheSameElement(this.myMethodPointer, group.myMethodPointer);
        }

        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        private PsiMethod getMethod() {
            return (PsiMethod)this.myMethodPointer.getElement();
        }

        @NotNull
        public String getText(UsageView view) {
            return this.myName;
        }

        public FileStatus getFileStatus() {
            PsiFile file2 = this.myMethodPointer.getContainingFile();
            return file2 == null ? null : NavigationItemFileStatus.get((NavigationItem)file2);
        }

        public boolean isValid() {
            PsiMethod method2 = this.getMethod();
            return method2 != null && method2.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (this.canNavigate()) {
                this.getMethod().navigate(focus);
            }
        }

        public boolean canNavigate() {
            return this.isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (!(usageGroup instanceof MethodUsageGroup)) {
                LOG.error("MethodUsageGroup expected but " + usageGroup.getClass() + " found");
            }
            MethodUsageGroup other = (MethodUsageGroup)usageGroup;
            if (SmartPointerManager.getInstance((Project)this.myProject).pointToTheSameElement(this.myMethodPointer, other.myMethodPointer)) {
                return 0;
            }
            if (!UsageViewSettings.getInstance().IS_SORT_MEMBERS_ALPHABETICALLY) {
                Segment segment1 = this.myMethodPointer.getRange();
                Segment segment2 = other.myMethodPointer.getRange();
                if (segment1 != null && segment2 != null) {
                    return segment1.getStartOffset() - segment2.getStartOffset();
                }
            }
            return this.myName.compareToIgnoreCase(other.myName);
        }

        public void calcData(DataKey key2, DataSink sink) {
            PsiMethod method2;
            if (!this.isValid()) {
                return;
            }
            if (CommonDataKeys.PSI_ELEMENT == key2) {
                sink.put(CommonDataKeys.PSI_ELEMENT, (Object)this.getMethod());
            }
            if (UsageView.USAGE_INFO_KEY == key2 && (method2 = this.getMethod()) != null) {
                sink.put(UsageView.USAGE_INFO_KEY, (Object)new UsageInfo((PsiElement)method2));
            }
        }
    }
}

