/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.util.JdkBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkBundleList {
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.JdkBundleList");
    private ArrayList<JdkBundle> bundleList = new ArrayList();
    private HashMap<String, JdkBundle> bundleMap = new HashMap();
    private HashMap<String, JdkBundle> nameVersionMap = new HashMap();

    public void addBundle(@NotNull JdkBundle bundle, boolean forceOldVersion) {
        JdkBundle bundleDescr = this.bundleMap.get(bundle.getLocation().getAbsolutePath());
        if (bundleDescr == null) {
            this.addMostRecent(bundle, forceOldVersion);
        } else {
            if (bundle.isBundled()) {
                bundleDescr.setBundled(true);
            }
            if (bundle.isBoot()) {
                bundleDescr.setBoot(true);
            }
        }
    }

    public JdkBundle getBundle(@NotNull String path) {
        return this.bundleMap.get(path);
    }

    private void addMostRecent(@NotNull JdkBundle bundleDescriptor, boolean forceOldVersion) {
        Pair<Version, Integer> latestVersionUpdate;
        JdkBundle latestJdk;
        boolean updateVersionMap;
        Pair<Version, Integer> versionUpdate = bundleDescriptor.getVersionUpdate();
        boolean bl = updateVersionMap = versionUpdate != null;
        if (!this.bundleList.isEmpty() && updateVersionMap && (latestJdk = this.nameVersionMap.get(bundleDescriptor.getNameVersion())) != null && (latestVersionUpdate = latestJdk.getVersionUpdate()) != null) {
            if ((Integer)latestVersionUpdate.second >= (Integer)versionUpdate.second) {
                if (!forceOldVersion) {
                    return;
                }
                updateVersionMap = false;
            } else if (!latestJdk.isBoot() && !latestJdk.isBundled()) {
                this.bundleList.remove(latestJdk);
                this.nameVersionMap.remove(latestJdk.getNameVersion());
                this.bundleMap.remove(latestJdk.getLocation().getAbsolutePath());
            }
        }
        this.bundleList.add(bundleDescriptor);
        this.bundleMap.put(bundleDescriptor.getLocation().getAbsolutePath(), bundleDescriptor);
        if (updateVersionMap) {
            this.nameVersionMap.put(bundleDescriptor.getNameVersion(), bundleDescriptor);
        }
    }

    public void addBundlesFromLocation(@NotNull String location, @Nullable Version minVer, @Nullable Version maxVer) {
        File jvmLocation = new File(location);
        if (!jvmLocation.exists()) {
            LOG.debug("Standard jvm location does not exists: " + jvmLocation);
            return;
        }
        File[] jvms = jvmLocation.listFiles();
        if (jvms == null) {
            LOG.debug("Cannot get jvm list from: " + jvmLocation);
            return;
        }
        for (File jvm : jvms) {
            Version jdkVer;
            JdkBundle jvmBundle = JdkBundle.createBundle(jvm, false, false);
            if (jvmBundle == null || jvmBundle.getVersionUpdate() == null || (jdkVer = jvmBundle.getVersion()) == null || minVer != null && jdkVer.lessThan(Integer.valueOf(minVer.major), Integer.valueOf(minVer.minor), Integer.valueOf(minVer.bugfix)) || maxVer != null && maxVer.lessThan(Integer.valueOf(jdkVer.major), Integer.valueOf(jdkVer.minor), Integer.valueOf(jdkVer.bugfix))) continue;
            this.addBundle(jvmBundle, false);
        }
    }

    public ArrayList<JdkBundle> toArrayList() {
        return this.bundleList;
    }

    public boolean contains(@NotNull String path) {
        return this.bundleMap.keySet().contains(path);
    }
}

