/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class MergingBackgroundExecutor<T> {
    private final Consumer<T> myConsumer;
    private final ExecutorService myExecutorService;

    public MergingBackgroundExecutor(@NotNull String name, int maxThreads, @NotNull Consumer<T> consumer2) {
        this.myConsumer = consumer2;
        this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)name, (int)maxThreads);
    }

    public void queue(@NotNull T t) {
        this.myExecutorService.execute(() -> this.myConsumer.consume(t));
    }

    @NotNull
    public static MergingBackgroundExecutor<Runnable> newRunnableExecutor(@NotNull String name, int maxThreads) {
        return new MergingBackgroundExecutor<Runnable>(name, maxThreads, runnable2 -> runnable2.run());
    }
}

