/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.Invoker;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface Command<T>
extends Supplier<T>,
Consumer<T> {

    public static final class Processor {
        public final Invoker foreground;
        public final Invoker background;

        public Processor(@NotNull Invoker foreground, @NotNull Invoker background) {
            this.foreground = foreground;
            this.background = background;
        }

        public <T> void consume(Consumer<T> consumer2, T value2) {
            if (consumer2 != null) {
                this.foreground.invokeLaterIfNeeded(() -> consumer2.accept(value2));
            }
        }

        public <T> void process(Command<T> command) {
            if (command != null) {
                this.background.invokeLaterIfNeeded(() -> this.consume(command, command.get()));
            }
        }

        public <T> void process(Supplier<T> supplier, Consumer<T> consumer2) {
            if (supplier != null) {
                this.background.invokeLaterIfNeeded(() -> this.consume(consumer2, supplier.get()));
            } else {
                this.consume(consumer2, null);
            }
        }

        public int getTaskCount() {
            return this.foreground.getTaskCount() + this.background.getTaskCount();
        }
    }
}

