/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import org.jetbrains.annotations.Nullable;

public class IntObjectLinkedMap<Entry extends MapEntry> {
    private final MapEntry myHeader;
    private final MapEntry[] myArray;
    private final int myCapacity;
    private int mySize;

    public IntObjectLinkedMap(int capacity) {
        this.myCapacity = capacity;
        this.myArray = new MapEntry[capacity * 8 / 5];
        this.myHeader = new MapEntry<Object>(0, null);
        this.myHeader.before = this.myHeader.after = this.myHeader;
    }

    @Nullable
    public Entry getEntry(int key2) {
        MapEntry candidate = this.myArray[this.getArrayIndex(key2)];
        while (candidate != null) {
            if (candidate.key == key2) {
                return (Entry)candidate;
            }
            candidate = candidate.next;
        }
        return null;
    }

    private int getArrayIndex(int key2) {
        return (key2 & Integer.MAX_VALUE) % this.myArray.length;
    }

    public void removeEntry(int key2) {
        int index = this.getArrayIndex(key2);
        MapEntry candidate = this.myArray[index];
        MapEntry prev = null;
        while (candidate != null) {
            if (candidate.key == key2) {
                if (prev == null) {
                    this.myArray[index] = candidate.next;
                } else {
                    prev.next = candidate.next;
                }
                candidate.before.after = candidate.after;
                candidate.after.before = candidate.before;
                candidate.after = null;
                candidate.before = null;
                candidate.next = null;
                --this.mySize;
                return;
            }
            prev = candidate;
            candidate = candidate.next;
        }
    }

    public Entry putEntry(Entry entry) {
        this.removeEntry(((MapEntry)entry).key);
        int index = this.getArrayIndex(((MapEntry)entry).key);
        ((MapEntry)entry).next = this.myArray[index];
        this.myArray[index] = entry;
        ((MapEntry)entry).before = this.myHeader.before;
        ((MapEntry)entry).after = this.myHeader;
        ((MapEntry)entry).before.after = entry;
        this.myHeader.before = entry;
        ++this.mySize;
        if (this.mySize <= this.myCapacity) {
            return null;
        }
        MapEntry eldest = this.myHeader.after;
        this.removeEntry(eldest.key);
        return (Entry)eldest;
    }

    public static class MapEntry<T> {
        public final int key;
        public final T value;
        MapEntry next;
        MapEntry before;
        MapEntry after;

        public MapEntry(int key2, T value2) {
            this.key = key2;
            this.value = value2;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

