/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.continuation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModalityIgnorantBackgroundableTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(ModalityIgnorantBackgroundableTask.class);

    public ModalityIgnorantBackgroundableTask(@Nullable Project project2, @NotNull String title, boolean canBeCancelled) {
        super(project2, title, canBeCancelled);
    }

    protected abstract void doInAwtIfFail(@NotNull Exception var1);

    protected abstract void doInAwtIfCancel();

    protected abstract void doInAwtIfSuccess();

    protected abstract void runImpl(@NotNull ProgressIndicator var1);

    public void run(@NotNull ProgressIndicator indicator) {
        try {
            this.runImpl(indicator);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            SwingUtilities.invokeLater(() -> this.doInAwtIfFail(e));
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (indicator.isCanceled()) {
                this.doInAwtIfCancel();
            } else {
                this.doInAwtIfSuccess();
            }
        });
    }
}

