/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.impl.ShortestPathFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CycleFinder<Node> {
    private final Graph<Node> myGraph;

    public CycleFinder(Graph<Node> graph) {
        this.myGraph = graph;
    }

    @NotNull
    public Set<List<Node>> getNodeCycles(final Node node) {
        HashSet<List<Node>> result2 = new HashSet<List<Node>>();
        Graph graphWithoutNode = new Graph<Node>(){

            public Collection<Node> getNodes() {
                Collection nodes = CycleFinder.this.myGraph.getNodes();
                nodes.remove(node);
                return nodes;
            }

            public Iterator<Node> getIn(Node n) {
                HashSet nodes = ContainerUtil.newHashSet((Iterator)CycleFinder.this.myGraph.getIn(n));
                nodes.remove(node);
                return nodes.iterator();
            }

            public Iterator<Node> getOut(Node n) {
                HashSet nodes = ContainerUtil.newHashSet((Iterator)CycleFinder.this.myGraph.getOut(n));
                nodes.remove(node);
                return nodes.iterator();
            }
        };
        HashSet inNodes = ContainerUtil.newHashSet((Iterator)this.myGraph.getIn(node));
        HashSet outNodes = ContainerUtil.newHashSet((Iterator)this.myGraph.getOut(node));
        HashSet retainNodes = new HashSet(inNodes);
        retainNodes.retainAll(outNodes);
        for (Object node1 : retainNodes) {
            result2.add(ContainerUtil.newArrayList((Object[])new Object[]{node1, node}));
        }
        inNodes.removeAll(retainNodes);
        outNodes.removeAll(retainNodes);
        ShortestPathFinder finder = new ShortestPathFinder(graphWithoutNode);
        for (Object fromNode : outNodes) {
            for (Object toNode : inNodes) {
                List shortestPath = finder.findPath(fromNode, toNode);
                if (shortestPath == null) continue;
                ArrayList<Node> path = new ArrayList<Node>(shortestPath.size() + 1);
                path.addAll(shortestPath);
                path.add(node);
                result2.add(path);
            }
        }
        return result2;
    }
}

