/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import org.jetbrains.annotations.NotNull;

public class AdditionalIndexedRootsScope
extends GlobalSearchScope {
    private final GlobalSearchScope myBaseScope;
    private final IndexableFileSet myFileSet;

    public AdditionalIndexedRootsScope(GlobalSearchScope baseScope) {
        this(baseScope, new AdditionalIndexableFileSet());
    }

    public AdditionalIndexedRootsScope(GlobalSearchScope baseScope, Class<? extends IndexableSetContributor> providerClass) {
        this(baseScope, new AdditionalIndexableFileSet((IndexableSetContributor)IndexableSetContributor.EP_NAME.findExtension(providerClass)));
    }

    public AdditionalIndexedRootsScope(GlobalSearchScope baseScope, IndexableFileSet myFileSet) {
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myFileSet = myFileSet;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return this.myBaseScope.contains(file2) || this.myFileSet.isInSet(file2);
    }

    public boolean isSearchOutsideRootModel() {
        return true;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        return this.myBaseScope.compare(file1, file2);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return this.myBaseScope.isSearchInModuleContent(aModule);
    }

    public boolean isSearchInLibraries() {
        return this.myBaseScope.isSearchInLibraries();
    }
}

