/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.IndexableSetContributor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileBasedIndexScanRunnableCollectorImpl
extends FileBasedIndexScanRunnableCollector {
    private final Project myProject;
    private final ProjectFileIndex myProjectFileIndex;
    private final FileTypeManager myFileTypeManager;

    public FileBasedIndexScanRunnableCollectorImpl(@NotNull Project project2) {
        this.myProject = project2;
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    @Override
    public boolean shouldCollect(@NotNull VirtualFile file2) {
        if (this.myProjectFileIndex.isInContent(file2) || this.myProjectFileIndex.isInLibraryClasses(file2) || this.myProjectFileIndex.isInLibrarySource(file2)) {
            return !this.myFileTypeManager.isFileIgnored(file2);
        }
        return false;
    }

    @Override
    public List<Runnable> collectScanRootRunnables(@NotNull ContentIterator processor2, ProgressIndicator indicator) {
        if (this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        tasks.add(() -> this.myProjectFileIndex.iterateContent(processor2));
        Set visitedRoots = ContainerUtil.newConcurrentSet();
        JBIterable contributedRoots = JBIterable.empty();
        for (IndexableSetContributor indexableSetContributor : (IndexableSetContributor[])Extensions.getExtensions((ExtensionPointName)IndexableSetContributor.EP_NAME)) {
            if (this.myProject.isDisposed()) {
                return tasks;
            }
            contributedRoots = contributedRoots.append((Iterable)IndexableSetContributor.getRootsToIndex((IndexableSetContributor)indexableSetContributor));
            contributedRoots = contributedRoots.append((Iterable)IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)indexableSetContributor, (Project)this.myProject));
        }
        for (IndexableSetContributor indexableSetContributor : (AdditionalLibraryRootsProvider[])Extensions.getExtensions(AdditionalLibraryRootsProvider.EP_NAME)) {
            if (this.myProject.isDisposed()) {
                return tasks;
            }
            contributedRoots = contributedRoots.append(indexableSetContributor.getAdditionalProjectLibraries(this.myProject), SyntheticLibrary::getSourceRoots);
        }
        for (VirtualFile root : contributedRoots) {
            if (!visitedRoots.add(root)) continue;
            tasks.add(() -> {
                if (this.myProject.isDisposed() || !root.isValid()) {
                    return;
                }
                FileBasedIndex.iterateRecursively((VirtualFile)root, (ContentIterator)processor2, (ProgressIndicator)indicator, (Set)visitedRoots, null);
            });
        }
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrSdkOrderEntry) || !orderEntry.isValid()) continue;
                LibraryOrSdkOrderEntry entry = (LibraryOrSdkOrderEntry)orderEntry;
                VirtualFile[] libSources = entry.getRootFiles(OrderRootType.SOURCES);
                VirtualFile[] libClasses = entry.getRootFiles(OrderRootType.CLASSES);
                VirtualFile[][] virtualFileArrayArray = new VirtualFile[][]{libSources, libClasses};
                int n = virtualFileArrayArray.length;
                for (int j = 0; j < n; ++j) {
                    VirtualFile[] roots;
                    for (VirtualFile root : roots = virtualFileArrayArray[j]) {
                        if (!visitedRoots.add(root)) continue;
                        tasks.add(() -> {
                            if (this.myProject.isDisposed() || module2.isDisposed() || !root.isValid()) {
                                return;
                            }
                            FileBasedIndex.iterateRecursively((VirtualFile)root, (ContentIterator)processor2, (ProgressIndicator)indicator, (Set)visitedRoots, (ProjectFileIndex)this.myProjectFileIndex);
                        });
                    }
                }
            }
        }
        return tasks;
    }
}

