/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.SubstitutedFileType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends UserDataHolderBase
implements FileContent {
    protected final VirtualFile myFile;
    protected final String myFileName;
    protected final FileType myFileType;
    protected final Charset myCharset;
    protected byte[] myContent;
    protected CharSequence myContentAsText;
    protected final long myStamp;
    protected byte[] myHash;
    private boolean myLighterASTShouldBeThreadSafe;
    private static final Key<PsiFile> CACHED_PSI = Key.create((String)"cached psi from content");

    public Project getProject() {
        return (Project)this.getUserData(IndexingDataKeys.PROJECT);
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psi = (PsiFile)this.getUserData(IndexingDataKeys.PSI_FILE);
        if (psi == null) {
            psi = (PsiFile)this.getUserData(CACHED_PSI);
        }
        if (psi == null) {
            psi = this.createFileFromText(this.getContentAsText());
            psi.putUserData(IndexingDataKeys.VIRTUAL_FILE, (Object)this.getFile());
            this.putUserData(CACHED_PSI, psi);
        }
        return psi;
    }

    @NotNull
    public LighterAST getLighterASTForPsiDependentIndex() {
        LighterAST lighterAST = (LighterAST)this.getUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY);
        if (lighterAST == null) {
            FileASTNode node = this.getPsiFileForPsiDependentIndex().getNode();
            lighterAST = this.myLighterASTShouldBeThreadSafe ? new TreeBackedLighterAST(node) : node.getLighterAST();
            this.putUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY, lighterAST);
        }
        return lighterAST;
    }

    void ensureThreadSafeLighterAST() {
        this.myLighterASTShouldBeThreadSafe = true;
    }

    public PsiFile createFileFromText(@NotNull CharSequence text) {
        Project project2 = this.getProject();
        if (project2 == null) {
            project2 = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        return FileContentImpl.createFileFromText(project2, text, (LanguageFileType)this.getFileTypeWithoutSubstitution(), this.myFile, this.myFileName);
    }

    @NotNull
    public static PsiFile createFileFromText(@NotNull Project project2, @NotNull CharSequence text, @NotNull LanguageFileType fileType, @NotNull VirtualFile file2, @NotNull String fileName) {
        Language language = fileType.getLanguage();
        Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, file2, project2);
        return PsiFileFactory.getInstance((Project)project2).createFileFromText(fileName, substitutedLanguage, text, false, false, true, file2);
    }

    public FileContentImpl(@NotNull VirtualFile file2, @NotNull CharSequence contentAsText, Charset charset) {
        this(file2, contentAsText, null, charset, -1L);
    }

    public FileContentImpl(@NotNull VirtualFile file2, @NotNull CharSequence contentAsText, Charset charset, long documentStamp) {
        this(file2, contentAsText, null, charset, documentStamp);
    }

    public FileContentImpl(@NotNull VirtualFile file2, @NotNull byte[] content) {
        this(file2, null, content, LoadTextUtil.detectCharsetAndSetBOM(file2, content), -1L);
    }

    public FileContentImpl(@NotNull VirtualFile file2) {
        this(file2, null, null, null, -1L);
    }

    private FileContentImpl(@NotNull VirtualFile file2, CharSequence contentAsText, byte[] content, Charset charset, long stamp) {
        this.myFile = file2;
        this.myContentAsText = contentAsText;
        this.myContent = content;
        this.myCharset = charset;
        this.myFileType = file2.getFileType();
        this.myFileName = file2.getName();
        this.myStamp = stamp;
    }

    @NotNull
    public FileType getSubstitutedFileType() {
        return SubstitutedFileType.substituteFileType(this.myFile, this.myFileType, this.getProject());
    }

    public static FileContent createByFile(@NotNull VirtualFile file2) {
        try {
            return new FileContentImpl(file2, file2.contentsToByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FileType getFileTypeWithoutSubstitution() {
        return this.myFileType;
    }

    @NotNull
    public FileType getFileType() {
        return this.getSubstitutedFileType();
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public String getFileName() {
        return this.myFileName;
    }

    public Charset getCharset() {
        return this.myCharset;
    }

    public long getStamp() {
        return this.myStamp;
    }

    public byte[] getContent() {
        if (this.myContent == null && this.myContentAsText != null) {
            try {
                this.myContent = this.myCharset != null ? this.myContentAsText.toString().getBytes(this.myCharset.name()) : this.myContentAsText.toString().getBytes();
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.myContent;
    }

    @NotNull
    public CharSequence getContentAsText() {
        if (this.myFileType.isBinary()) {
            throw new IllegalDataException("Cannot obtain text for binary file type : " + this.myFileType.getDescription());
        }
        CharSequence content = (CharSequence)this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content != null) {
            return content;
        }
        if (this.myContentAsText == null && this.myContent != null) {
            this.myContentAsText = LoadTextUtil.getTextByBinaryPresentation(this.myContent, this.myCharset);
            this.myContent = null;
        }
        return this.myContentAsText;
    }

    public String toString() {
        return this.myFileName;
    }

    @Nullable
    public byte[] getHash() {
        return this.myHash;
    }

    public void setHash(byte[] hash) {
        this.myHash = hash;
    }

    @NotNull
    public PsiFile getPsiFileForPsiDependentIndex() {
        PsiFile existingPsi;
        PsiDocumentManager psiDocumentManager;
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.getFile());
        PsiFile psi = null;
        if (document != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject())).isUncommited(document) && (existingPsi = psiDocumentManager.getPsiFile(document)) != null) {
            psi = existingPsi;
        }
        if (psi == null) {
            psi = this.getPsiFile();
        }
        return psi;
    }

    public static class IllegalDataException
    extends RuntimeException {
        public IllegalDataException(String message2) {
            super(message2);
        }
    }
}

