/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class IndexAccessValidator {
    private final ThreadLocal<ID<?, ?>> ourAlreadyProcessingIndices = new ThreadLocal();

    public void checkAccessingIndexDuringOtherIndexProcessing(@NotNull ID<?, ?> indexKey) {
        ID<?, ?> alreadyProcessingIndex = this.ourAlreadyProcessingIndices.get();
        if (alreadyProcessingIndex != null && alreadyProcessingIndex != indexKey) {
            String message2 = MessageFormat.format("Accessing ''{0}'' during processing ''{1}''. Nested different indices processing may cause deadlock", indexKey.toString(), alreadyProcessingIndex.toString());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(message2);
            }
            Logger.getInstance(FileBasedIndexImpl.class).error(message2);
        }
    }

    public void startedProcessingActivityForIndex(ID<?, ?> indexId) {
        this.ourAlreadyProcessingIndices.set(indexId);
    }

    public void stoppedProcessingActivityForIndex(ID<?, ?> indexId) {
        this.ourAlreadyProcessingIndices.set(null);
    }
}

