/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.indexing.ID;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class IndexInfrastructure {
    private static final boolean ourUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private static final String STUB_VERSIONS = ".versions";
    private static final String PERSISTENT_INDEX_DIRECTORY_NAME = ".persistent";
    private static final boolean ourDoParallelIndicesInitialization = SystemProperties.getBooleanProperty((String)"idea.parallel.indices.initialization", (boolean)false);
    public static final boolean ourDoAsyncIndicesInitialization = SystemProperties.getBooleanProperty((String)"idea.async.indices.initialization", (boolean)true);
    private static final ExecutorService ourGenesisExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"IndexInfrastructure pool");

    private IndexInfrastructure() {
    }

    @NotNull
    public static File getVersionFile(@NotNull ID<?, ?> indexName) {
        return new File(IndexInfrastructure.getIndexDirectory(indexName, true), indexName + ".ver");
    }

    @NotNull
    public static File getStorageFile(@NotNull ID<?, ?> indexName) {
        return new File(IndexInfrastructure.getIndexRootDir(indexName), indexName.toString());
    }

    @NotNull
    public static File getInputIndexStorageFile(@NotNull ID<?, ?> indexName) {
        return new File(IndexInfrastructure.getIndexRootDir(indexName), indexName + "_inputs");
    }

    @NotNull
    public static File getIndexRootDir(@NotNull ID<?, ?> indexName) {
        return IndexInfrastructure.getIndexDirectory(indexName, false);
    }

    public static File getPersistentIndexRoot() {
        File indexDir = new File(PathManager.getIndexRoot() + File.separator + PERSISTENT_INDEX_DIRECTORY_NAME);
        indexDir.mkdirs();
        return indexDir;
    }

    @NotNull
    public static File getPersistentIndexRootDir(@NotNull ID<?, ?> indexName) {
        return IndexInfrastructure.getIndexDirectory(indexName, false, PERSISTENT_INDEX_DIRECTORY_NAME);
    }

    @NotNull
    private static File getIndexDirectory(@NotNull ID<?, ?> indexName, boolean forVersion) {
        return IndexInfrastructure.getIndexDirectory(indexName, forVersion, "");
    }

    @NotNull
    private static File getIndexDirectory(@NotNull ID<?, ?> indexName, boolean forVersion, String relativePath) {
        File indexDir;
        String dirName = indexName.toString().toLowerCase(Locale.US);
        if (indexName instanceof StubIndexKey) {
            indexDir = new File(IndexInfrastructure.getIndexDirectory(StubUpdatingIndex.INDEX_ID, false, relativePath), forVersion ? STUB_VERSIONS : dirName);
        } else {
            if (relativePath.length() > 0) {
                relativePath = File.separator + relativePath;
            }
            indexDir = new File(PathManager.getIndexRoot() + relativePath, dirName);
        }
        indexDir.mkdirs();
        return indexDir;
    }

    @Nullable
    public static VirtualFile findFileById(@NotNull PersistentFS fs, int id) {
        VirtualFile testFile;
        if (ourUnitTestMode && (testFile = IndexInfrastructure.findTestFile(id)) != null) {
            return testFile;
        }
        return fs.findFileById(id);
    }

    @Nullable
    public static VirtualFile findFileByIdIfCached(@NotNull PersistentFS fs, int id) {
        VirtualFile testFile;
        if (ourUnitTestMode && (testFile = IndexInfrastructure.findTestFile(id)) != null) {
            return testFile;
        }
        return fs.findFileByIdIfCached(id);
    }

    @Nullable
    private static VirtualFile findTestFile(int id) {
        return DummyFileSystem.getInstance().findById(id);
    }

    public static <T> Future<T> submitGenesisTask(Callable<T> action) {
        return ourGenesisExecutor.submit(action);
    }

    public static abstract class DataInitialization<T>
    implements Callable<T> {
        private final List<ThrowableRunnable> myNestedInitializationTasks = new ArrayList<ThrowableRunnable>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T call() throws Exception {
            long started = System.nanoTime();
            try {
                this.prepare();
                this.runParallelNestedInitializationTasks();
                T t = this.finish();
                return t;
            }
            finally {
                Logger.getInstance((String)this.getClass().getName()).info("Initialization done:" + (System.nanoTime() - started) / 1000000L);
            }
        }

        protected T finish() {
            return null;
        }

        protected void prepare() {
        }

        protected abstract void onThrowable(Throwable var1);

        public void addNestedInitializationTask(ThrowableRunnable nestedInitializationTask) {
            this.myNestedInitializationTasks.add(nestedInitializationTask);
        }

        private void runParallelNestedInitializationTasks() throws InterruptedException {
            int numberOfTasksToExecute = this.myNestedInitializationTasks.size();
            if (numberOfTasksToExecute == 0) {
                return;
            }
            CountDownLatch proceedLatch = new CountDownLatch(numberOfTasksToExecute);
            if (ourDoParallelIndicesInitialization) {
                BoundedTaskExecutor taskExecutor = new BoundedTaskExecutor("IndexInfrastructure.DataInitialization.runParallelNestedInitializationTasks", (Executor)PooledThreadExecutor.INSTANCE, CacheUpdateRunner.indexingThreadCount());
                for (ThrowableRunnable callable : this.myNestedInitializationTasks) {
                    taskExecutor.execute(() -> this.executeNestedInitializationTask(callable, proceedLatch));
                }
                proceedLatch.await();
                taskExecutor.shutdown();
            } else {
                for (ThrowableRunnable callable : this.myNestedInitializationTasks) {
                    this.executeNestedInitializationTask(callable, proceedLatch);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeNestedInitializationTask(ThrowableRunnable callable, CountDownLatch proceedLatch) {
            Application app = ApplicationManager.getApplication();
            try {
                if (app.isDisposed() || app.isDisposeInProgress()) {
                    return;
                }
                callable.run();
            }
            catch (Throwable t) {
                this.onThrowable(t);
            }
            finally {
                proceedLatch.countDown();
            }
        }
    }
}

