/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndexedFilesListener
extends VirtualFileAdapter
implements BulkFileListener {
    private final ManagingFS myManagingFS = ManagingFS.getInstance();
    @Nullable
    private final String myConfigPath = IndexedFilesListener.calcConfigPath(PathManager.getConfigPath());
    @Nullable
    private final String myLogPath = IndexedFilesListener.calcConfigPath(PathManager.getLogPath());

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        this.buildIndicesForFileRecursively(event.getFile(), false);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        this.buildIndicesForFileRecursively(event.getFile(), false);
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        this.buildIndicesForFileRecursively(event.getFile(), false);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        this.invalidateIndicesRecursively(event.getFile(), false);
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        this.invalidateIndicesRecursively(event.getFile(), true);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        this.buildIndicesForFileRecursively(event.getFile(), true);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("name")) {
            this.invalidateIndicesRecursively(event.getFile(), false);
        } else if (propertyName.equals("encoding")) {
            this.invalidateIndicesRecursively(event.getFile(), true);
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals("name")) {
            this.buildIndicesForFileRecursively(event.getFile(), false);
        } else if (propertyName.equals("encoding")) {
            this.buildIndicesForFileRecursively(event.getFile(), true);
        }
    }

    protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
        if (file2.isDirectory()) {
            ContentIterator iterator = fileOrDir -> {
                this.buildIndicesForFile(fileOrDir, contentChange);
                return true;
            };
            this.iterateIndexableFiles(file2, iterator);
        } else {
            this.buildIndicesForFile(file2, contentChange);
        }
    }

    protected boolean invalidateIndicesForFile(VirtualFile file2, boolean contentChange) {
        if (this.isUnderConfigOrSystem(file2)) {
            return false;
        }
        if (file2.isDirectory()) {
            this.doInvalidateIndicesForFile(file2, contentChange);
            if (!FileBasedIndexImpl.isMock(file2) && !this.myManagingFS.wereChildrenAccessed(file2)) {
                return false;
            }
        } else {
            this.doInvalidateIndicesForFile(file2, contentChange);
        }
        return true;
    }

    protected abstract void iterateIndexableFiles(VirtualFile var1, ContentIterator var2);

    protected abstract void buildIndicesForFile(VirtualFile var1, boolean var2);

    protected abstract void doInvalidateIndicesForFile(VirtualFile var1, boolean var2);

    protected void invalidateIndicesRecursively(@NotNull VirtualFile file2, final boolean contentChange) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                return IndexedFilesListener.this.invalidateIndicesForFile(file2, contentChange);
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).iterInDbChildren() : null;
            }
        });
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)this, (VFileEvent)vFileEvent);
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        for (VFileEvent vFileEvent : events) {
            BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)this, (VFileEvent)vFileEvent);
        }
    }

    @Nullable
    private static String calcConfigPath(@NotNull String path) {
        try {
            String _path = FileUtil.toSystemIndependentName((String)new File(path).getCanonicalPath());
            return _path.endsWith("/") ? _path : _path + "/";
        }
        catch (IOException e) {
            FileBasedIndexImpl.LOG.info((Throwable)e);
            return null;
        }
    }

    private boolean isUnderConfigOrSystem(@NotNull VirtualFile file2) {
        String filePath = file2.getPath();
        return this.myConfigPath != null && FileUtil.startsWith((String)filePath, (String)this.myConfigPath) || this.myLogPath != null && FileUtil.startsWith((String)filePath, (String)this.myLogPath);
    }
}

