/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightDirectoryIndex<T> {
    private final ConcurrentIntObjectMap<T> myInfoCache = ContainerUtil.createConcurrentIntObjectMap();
    private final T myDefValue;
    private final Consumer<LightDirectoryIndex<T>> myInitializer;

    public LightDirectoryIndex(@NotNull Disposable parentDisposable, @NotNull T defValue, @NotNull Consumer<LightDirectoryIndex<T>> initializer) {
        this.myDefValue = defValue;
        this.myInitializer = initializer;
        this.resetIndex();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                LightDirectoryIndex.this.resetIndex();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 != null && !file2.isDirectory()) continue;
                    LightDirectoryIndex.this.resetIndex();
                    break;
                }
            }
        });
    }

    public void resetIndex() {
        this.myInfoCache.clear();
        this.myInitializer.consume((Object)this);
    }

    public void putInfo(@Nullable VirtualFile file2, @NotNull T value2) {
        if (!(file2 instanceof VirtualFileWithId)) {
            return;
        }
        this.cacheInfo(file2, value2);
    }

    @NotNull
    public T getInfoForFile(@Nullable VirtualFile file2) {
        VirtualFile dir;
        if (!(file2 instanceof VirtualFileWithId)) {
            return this.myDefValue;
        }
        if (!file2.isDirectory()) {
            T info = this.getCachedInfo(file2);
            if (info != null) {
                return info;
            }
            dir = file2.getParent();
        } else {
            dir = file2;
        }
        int count = 0;
        for (VirtualFile root = dir; root != null; root = root.getParent()) {
            if (++count > 1000) {
                throw new IllegalStateException("Possible loop in tree, started at " + dir.getName());
            }
            T info = this.getCachedInfo(root);
            if (info == null) continue;
            if (!dir.equals(root)) {
                this.cacheInfos(dir, root, info);
            }
            return info;
        }
        return this.cacheInfos(dir, null, this.myDefValue);
    }

    @NotNull
    private T cacheInfos(VirtualFile dir, @Nullable VirtualFile stopAt, @NotNull T info) {
        while (dir != null) {
            this.cacheInfo(dir, info);
            if (dir.equals(stopAt)) break;
            dir = dir.getParent();
        }
        return info;
    }

    private void cacheInfo(VirtualFile file2, T info) {
        this.myInfoCache.put(((VirtualFileWithId)file2).getId(), info);
    }

    private T getCachedInfo(VirtualFile file2) {
        return (T)this.myInfoCache.get(((VirtualFileWithId)file2).getId());
    }
}

