/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.indexing.ID;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PerIndexDocumentVersionMap {
    private static final int INVALID_STAMP = -1;
    private volatile int mapVersion;
    private static final Key<List<IdVersionInfo>> KEY = Key.create((String)"UnsavedDocIdVersionInfo");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long set(@NotNull Document document, @NotNull ID<?, ?> indexId, long value2) {
        List list = (List)document.getUserData(KEY);
        if (list == null) {
            list = (List)((UserDataHolderEx)document).putUserDataIfAbsent(KEY, new ArrayList());
        }
        List list2 = list;
        synchronized (list2) {
            for (IdVersionInfo info : list) {
                if (info.id != indexId) continue;
                long old = info.docVersion;
                if (info.mapVersion != this.mapVersion) {
                    old = -1L;
                    info.mapVersion = this.mapVersion;
                }
                info.docVersion = value2;
                return old;
            }
            list.add(new IdVersionInfo(indexId, value2, this.mapVersion));
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(@NotNull Document document, @NotNull ID<?, ?> indexId) {
        List list = (List)document.getUserData(KEY);
        if (list == null) {
            return -1L;
        }
        List list2 = list;
        synchronized (list2) {
            for (IdVersionInfo info : list) {
                if (info.id != indexId) continue;
                long old = info.docVersion;
                if (info.mapVersion != this.mapVersion) {
                    return -1L;
                }
                return old;
            }
            return -1L;
        }
    }

    public void clearForDocument(@NotNull Document document) {
        document.putUserData(KEY, new ArrayList());
    }

    public void clear() {
        ++this.mapVersion;
    }

    private static class IdVersionInfo {
        private final ID<?, ?> id;
        private int mapVersion;
        private long docVersion;

        private IdVersionInfo(@NotNull ID<?, ?> id, long docVersion, int mapVersion) {
            this.docVersion = docVersion;
            this.mapVersion = mapVersion;
            this.id = id;
        }
    }
}

