/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SingleEntryIndexer<V>
implements DataIndexer<Integer, V, FileContent> {
    private final boolean myAcceptNullValues;

    protected SingleEntryIndexer(boolean acceptNullValues) {
        this.myAcceptNullValues = acceptNullValues;
    }

    @NotNull
    public final Map<Integer, V> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            return Collections.emptyMap();
        }
        V value2 = this.computeValue(inputData);
        if (value2 == null && !this.myAcceptNullValues) {
            return Collections.emptyMap();
        }
        int key2 = Math.abs(FileBasedIndex.getFileId((VirtualFile)inputData.getFile()));
        return Collections.singletonMap(key2, value2);
    }

    @Nullable
    protected abstract V computeValue(@NotNull FileContent var1);
}

