/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.CompressionUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.ByteSequenceDataExternalizer;
import com.intellij.util.indexing.ContentHashesSupport;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import gnu.trove.THashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SnapshotInputMappings<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(SnapshotInputMappings.class);
    private static final boolean doReadSavedPersistentData = SystemProperties.getBooleanProperty((String)"idea.read.saved.persistent.index", (boolean)true);
    private final ID<Key, Value> myIndexId;
    private final DataExternalizer<Value> myValueExternalizer;
    private final IndexExtension<Key, Value, Input> myIndexExtension;
    private final DataIndexer<Key, Value, Input> myIndexer;
    private volatile PersistentHashMap<Integer, ByteSequence> myContents;
    private volatile PersistentHashMap<Integer, Integer> myInputsSnapshotMapping;
    private volatile PersistentHashMap<Integer, String> myIndexingTrace;
    private final DataExternalizer<Collection<Key>> mySnapshotIndexExternalizer;
    private boolean myIsPsiBackedIndex;
    private static final Key<Integer> ourSavedContentHashIdKey = Key.create((String)"saved.content.hash.id");
    private static final Key<Integer> ourSavedUncommittedHashIdKey = Key.create((String)"saved.uncommitted.hash.id");
    private static final ThreadLocalCachedByteArray ourSpareByteArray = new ThreadLocalCachedByteArray();

    public SnapshotInputMappings(IndexExtension<Key, Value, Input> indexExtension) throws IOException {
        this.myIndexId = indexExtension.getName();
        this.myIsPsiBackedIndex = indexExtension instanceof PsiDependentIndex;
        this.mySnapshotIndexExternalizer = VfsAwareMapReduceIndex.createInputsIndexExternalizer(indexExtension);
        this.myValueExternalizer = indexExtension.getValueExternalizer();
        this.myIndexer = indexExtension.getIndexer();
        this.myIndexExtension = indexExtension;
        this.createMaps();
    }

    @NotNull
    public Map<Key, Value> readInputKeys(int inputId) throws IOException {
        ByteSequence byteSequence;
        Integer currentHashId = this.readInputHashId(inputId);
        if (currentHashId != null && (byteSequence = this.readContents(currentHashId)) != null) {
            return this.deserializeSavedPersistentData(byteSequence);
        }
        return Collections.emptyMap();
    }

    @NotNull
    Snapshot<Key, Value> readPersistentDataOrMap(@NotNull Input content) {
        int hashId;
        Map<Key, Value> data = null;
        boolean havePersistentData = false;
        boolean skippedReadingPersistentDataButMayHaveIt = false;
        try {
            FileContent fileContent = (FileContent)content;
            hashId = this.getHashOfContent(fileContent);
            if (doReadSavedPersistentData) {
                if (!this.myContents.isBusyReading() || DebugAssertions.EXTRA_SANITY_CHECKS) {
                    ByteSequence bytes = this.readContents(hashId);
                    if (bytes != null) {
                        Map contentData;
                        boolean sameValueForSavedIndexedResultAndCurrentOne;
                        data = this.deserializeSavedPersistentData(bytes);
                        havePersistentData = true;
                        if (DebugAssertions.EXTRA_SANITY_CHECKS && !(sameValueForSavedIndexedResultAndCurrentOne = (contentData = this.myIndexer.map(content)).equals(data))) {
                            DebugAssertions.error((String)"Unexpected difference in indexing of %s by index %s, file type %s, charset %s\ndiff %s\nprevious indexed info %s", (Object[])new Object[]{fileContent.getFile(), this.myIndexId, fileContent.getFileType().getName(), ((FileContentImpl)fileContent).getCharset(), this.buildDiff(data, contentData), this.myIndexingTrace.get((Object)hashId)});
                        }
                    }
                } else {
                    skippedReadingPersistentDataButMayHaveIt = true;
                }
            } else {
                havePersistentData = this.myContents.containsMapping((Object)hashId);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (data == null) {
            data = this.myIndexer.map(content);
            if (DebugAssertions.DEBUG) {
                MapReduceIndex.checkValuesHaveProperEqualsAndHashCode(data, this.myIndexId, this.myValueExternalizer);
            }
        }
        if (!havePersistentData) {
            boolean saved = this.savePersistentData(data, hashId, skippedReadingPersistentDataButMayHaveIt);
            if (DebugAssertions.EXTRA_SANITY_CHECKS && saved) {
                FileContent fileContent = (FileContent)content;
                try {
                    this.myIndexingTrace.put((Object)hashId, (Object)(((FileContentImpl)fileContent).getCharset() + "," + fileContent.getFileType().getName() + "," + fileContent.getFile().getPath() + "," + ExceptionUtil.getThrowableText((Throwable)new Throwable())));
                }
                catch (IOException ex) {
                    LOG.error((Throwable)ex);
                }
            }
        }
        return new Snapshot(data, hashId);
    }

    public void putInputHash(int inputId, int hashId) throws IOException {
        try {
            if (SharedIndicesData.ourFileSharedIndicesEnabled) {
                SharedIndicesData.associateFileData(inputId, this.myIndexId, hashId, EnumeratorIntegerDescriptor.INSTANCE);
            }
            if (this.myInputsSnapshotMapping != null) {
                this.myInputsSnapshotMapping.put((Object)inputId, (Object)hashId);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void flush() {
        if (this.myContents != null) {
            this.myContents.force();
        }
        if (this.myInputsSnapshotMapping != null) {
            this.myInputsSnapshotMapping.force();
        }
        if (this.myIndexingTrace != null) {
            this.myIndexingTrace.force();
        }
    }

    public void clear() throws IOException {
        List<File> baseDirs = ContainerUtil.list((Object[])new PersistentHashMap[]{this.myContents, this.myIndexingTrace, this.myInputsSnapshotMapping}).stream().filter(Objects::nonNull).map(PersistentHashMap::getBaseFile).collect(Collectors.toList());
        try {
            this.close();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        baseDirs.forEach(PersistentHashMap::deleteFilesStartingWith);
        this.createMaps();
    }

    public void close() throws IOException {
        if (this.myContents != null) {
            this.myContents.close();
        }
        if (this.myInputsSnapshotMapping != null) {
            this.myInputsSnapshotMapping.close();
        }
        if (this.myIndexingTrace != null) {
            this.myIndexingTrace.close();
        }
    }

    private void createMaps() throws IOException {
        this.myContents = this.createContentsIndex();
        this.myIndexingTrace = DebugAssertions.EXTRA_SANITY_CHECKS ? this.createIndexingTrace() : null;
        this.myInputsSnapshotMapping = !SharedIndicesData.ourFileSharedIndicesEnabled || SharedIndicesData.DO_CHECKS ? this.createInputSnapshotMapping() : null;
    }

    private PersistentHashMap<Integer, ByteSequence> createContentsIndex() throws IOException {
        File saved = new File(IndexInfrastructure.getPersistentIndexRootDir(this.myIndexId), "values");
        try {
            return new PersistentHashMap(saved, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)ByteSequenceDataExternalizer.INSTANCE);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)saved);
            throw ex;
        }
    }

    private PersistentHashMap<Integer, Integer> createInputSnapshotMapping() throws IOException {
        File fileIdToHashIdFile = new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "fileIdToHashId");
        try {
            return new PersistentHashMap<Integer, Integer>(fileIdToHashIdFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE, 4096){

                protected boolean wantNonnegativeIntegralValues() {
                    return true;
                }
            };
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)fileIdToHashIdFile);
            throw ex;
        }
    }

    private PersistentHashMap<Integer, String> createIndexingTrace() throws IOException {
        File mapFile = new File(IndexInfrastructure.getIndexRootDir(this.myIndexId), "indextrace");
        try {
            return new PersistentHashMap(mapFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<String>(){

                public void save(@NotNull DataOutput out, String value2) throws IOException {
                    out.write((byte[])CompressionUtil.compressCharSequence((CharSequence)value2, (Charset)Charset.defaultCharset()));
                }

                public String read(@NotNull DataInput in) throws IOException {
                    byte[] b = new byte[((InputStream)((Object)in)).available()];
                    in.readFully(b);
                    return (String)CompressionUtil.uncompressCharSequence((Object)b, (Charset)Charset.defaultCharset());
                }
            }, 4096);
        }
        catch (IOException ex) {
            IOUtil.deleteAllFilesStartingWith((File)mapFile);
            throw ex;
        }
    }

    private Integer readInputHashId(int inputId) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            Integer hashId = (Integer)SharedIndicesData.recallFileData(inputId, this.myIndexId, EnumeratorIntegerDescriptor.INSTANCE);
            if (hashId == null) {
                hashId = 0;
            }
            if (this.myInputsSnapshotMapping == null) {
                return hashId;
            }
            Integer hashIdFromInputSnapshotMapping = (Integer)this.myInputsSnapshotMapping.get((Object)inputId);
            if (hashId == 0 && hashIdFromInputSnapshotMapping != 0 || !Comparing.equal((Object)hashIdFromInputSnapshotMapping, (Object)hashId)) {
                SharedIndicesData.associateFileData(inputId, this.myIndexId, hashIdFromInputSnapshotMapping, EnumeratorIntegerDescriptor.INSTANCE);
                if (hashId != 0) {
                    LOG.error("Unexpected indexing diff with hashid " + this.myIndexId + ", file:" + IndexInfrastructure.findFileById(PersistentFS.getInstance(), inputId) + "," + hashIdFromInputSnapshotMapping + "," + hashId);
                }
                hashId = hashIdFromInputSnapshotMapping;
            }
            return hashId;
        }
        return (Integer)this.myInputsSnapshotMapping.get((Object)inputId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteSequence readContents(Integer hashId) throws IOException {
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (SharedIndicesData.DO_CHECKS) {
                PersistentHashMap<Integer, ByteSequence> persistentHashMap = this.myContents;
                synchronized (persistentHashMap) {
                    ByteSequence contentBytes = SharedIndicesData.recallContentData(hashId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
                    ByteSequence contentBytesFromContents = (ByteSequence)this.myContents.get((Object)hashId);
                    if (contentBytes == null && contentBytesFromContents != null || !Comparing.equal((Object)contentBytesFromContents, (Object)contentBytes)) {
                        SharedIndicesData.associateContentData(hashId, this.myIndexId, contentBytesFromContents, ByteSequenceDataExternalizer.INSTANCE);
                        if (contentBytes != null) {
                            LOG.error("Unexpected indexing diff with hashid " + this.myIndexId + "," + hashId);
                        }
                        contentBytes = contentBytesFromContents;
                    }
                    return contentBytes;
                }
            }
            return SharedIndicesData.recallContentData(hashId, this.myIndexId, ByteSequenceDataExternalizer.INSTANCE);
        }
        return (ByteSequence)this.myContents.get((Object)hashId);
    }

    private Map<Key, Value> deserializeSavedPersistentData(ByteSequence bytes) throws IOException {
        DataInputStream stream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes.getBytes(), bytes.getOffset(), bytes.getLength()));
        int pairs = DataInputOutputUtil.readINT((DataInput)stream);
        if (pairs == 0) {
            return Collections.emptyMap();
        }
        THashMap result2 = new THashMap(pairs);
        while (stream.available() > 0) {
            Object value2 = this.myIndexExtension.getValueExternalizer().read((DataInput)stream);
            Collection keys = (Collection)this.mySnapshotIndexExternalizer.read((DataInput)stream);
            for (Object k : keys) {
                result2.put(k, value2);
            }
        }
        return result2;
    }

    private Integer getHashOfContent(FileContent content) throws IOException {
        Integer previouslyCalculatedContentHashId;
        FileType fileType = content.getFileType();
        if (this.myIsPsiBackedIndex && content instanceof FileContentImpl) {
            PsiDocumentManager psiDocumentManager;
            Document document;
            Integer previouslyCalculatedUncommittedHashId = (Integer)content.getUserData(ourSavedUncommittedHashIdKey);
            if (previouslyCalculatedUncommittedHashId == null && (document = FileDocumentManager.getInstance().getCachedDocument(content.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)content.getProject())).isUncommited(document)) {
                PsiFile file2 = psiDocumentManager.getCachedPsiFile(document);
                Charset charset = ((FileContentImpl)content).getCharset();
                if (file2 != null) {
                    previouslyCalculatedUncommittedHashId = ContentHashesSupport.calcContentHashIdWithFileType(file2.getText().getBytes(charset), charset, fileType);
                    content.putUserData(ourSavedUncommittedHashIdKey, (Object)previouslyCalculatedUncommittedHashId);
                }
            }
            if (previouslyCalculatedUncommittedHashId != null) {
                return previouslyCalculatedUncommittedHashId;
            }
        }
        if ((previouslyCalculatedContentHashId = (Integer)content.getUserData(ourSavedContentHashIdKey)) == null) {
            byte[] hash;
            byte[] byArray = hash = content instanceof FileContentImpl ? ((FileContentImpl)content).getHash() : null;
            if (hash == null) {
                if (fileType.isBinary()) {
                    previouslyCalculatedContentHashId = ContentHashesSupport.calcContentHashId(content.getContent(), fileType);
                } else {
                    Charset charset = content instanceof FileContentImpl ? ((FileContentImpl)content).getCharset() : null;
                    previouslyCalculatedContentHashId = ContentHashesSupport.calcContentHashIdWithFileType(content.getContent(), charset, fileType);
                }
            } else {
                previouslyCalculatedContentHashId = ContentHashesSupport.enumerateHash(hash);
            }
            content.putUserData(ourSavedContentHashIdKey, (Object)previouslyCalculatedContentHashId);
        }
        return previouslyCalculatedContentHashId;
    }

    private StringBuilder buildDiff(Map<Key, Value> data, Map<Key, Value> contentData) {
        Value value2;
        StringBuilder moreInfo = new StringBuilder();
        if (contentData.size() != data.size()) {
            moreInfo.append("Indexer has different number of elements, previously ").append(data.size()).append(" after ").append(contentData.size()).append("\n");
        } else {
            moreInfo.append("total ").append(contentData.size()).append(" entries\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : contentData.entrySet()) {
            if (!data.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("Previous data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value2 = data.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value2)) continue;
            moreInfo.append("Previous data has different value for key:").append(keyValueEntry.getKey()).append(", new value ").append(keyValueEntry.getValue()).append(", oldValue:").append(value2).append("\n");
        }
        for (Map.Entry<Key, Value> keyValueEntry : data.entrySet()) {
            if (!contentData.containsKey(keyValueEntry.getKey())) {
                moreInfo.append("New data doesn't contain:").append(keyValueEntry.getKey()).append(" with value ").append(keyValueEntry.getValue()).append("\n");
                continue;
            }
            value2 = contentData.get(keyValueEntry.getKey());
            if (Comparing.equal(keyValueEntry.getValue(), value2)) continue;
            moreInfo.append("New data has different value for key:").append(keyValueEntry.getKey()).append(" new value ").append(value2).append(", oldValue:").append(keyValueEntry.getValue()).append("\n");
        }
        return moreInfo;
    }

    private boolean savePersistentData(Map<Key, Value> data, int id, boolean delayedReading) {
        try {
            if (delayedReading && this.myContents.containsMapping((Object)id)) {
                return false;
            }
            BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(ourSpareByteArray.getBuffer(4 * data.size()));
            DataOutputStream stream = new DataOutputStream((OutputStream)out);
            int size = data.size();
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)size);
            if (size > 0) {
                THashMap values = new THashMap();
                List keysForNullValue = null;
                for (Map.Entry<Key, Value> e : data.entrySet()) {
                    List keys;
                    Value value2 = e.getValue();
                    List list = keys = value2 != null ? (List)values.get(value2) : keysForNullValue;
                    if (keys == null) {
                        if (value2 != null) {
                            keys = new SmartList();
                            values.put(value2, (Object)keys);
                        } else {
                            keys = keysForNullValue = new SmartList();
                        }
                    }
                    keys.add(e.getKey());
                }
                if (keysForNullValue != null) {
                    this.myValueExternalizer.save((DataOutput)stream, null);
                    this.mySnapshotIndexExternalizer.save((DataOutput)stream, keysForNullValue);
                }
                for (Map.Entry<Object, Object> value3 : values.keySet()) {
                    this.myValueExternalizer.save((DataOutput)stream, value3);
                    this.mySnapshotIndexExternalizer.save((DataOutput)stream, values.get(value3));
                }
            }
            this.saveContents(id, out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveContents(int id, BufferExposingByteArrayOutputStream out) throws IOException {
        ByteSequence byteSequence = new ByteSequence(out.getInternalBuffer(), 0, out.size());
        if (SharedIndicesData.ourFileSharedIndicesEnabled) {
            if (SharedIndicesData.DO_CHECKS) {
                PersistentHashMap<Integer, ByteSequence> persistentHashMap = this.myContents;
                synchronized (persistentHashMap) {
                    this.myContents.put((Object)id, (Object)byteSequence);
                    SharedIndicesData.associateContentData(id, this.myIndexId, byteSequence, ByteSequenceDataExternalizer.INSTANCE);
                }
            } else {
                SharedIndicesData.associateContentData(id, this.myIndexId, byteSequence, ByteSequenceDataExternalizer.INSTANCE);
            }
        } else {
            this.myContents.put((Object)id, (Object)byteSequence);
        }
    }

    static class Snapshot<Key, Value> {
        private final Map<Key, Value> myData;
        private final int hashId;

        private Snapshot(Map<Key, Value> data, int id) {
            this.myData = data;
            this.hashId = id;
        }

        public Map<Key, Value> getData() {
            return this.myData;
        }

        public int getHashId() {
            return this.hashId;
        }
    }
}

