/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeHttpClientHelpers {
    private IdeHttpClientHelpers() {
    }

    @NotNull
    private static HttpConfigurable getHttpConfigurable() {
        return HttpConfigurable.getInstance();
    }

    private static boolean isHttpProxyEnabled() {
        return IdeHttpClientHelpers.getHttpConfigurable().USE_HTTP_PROXY;
    }

    private static boolean isProxyAuthenticationEnabled() {
        return IdeHttpClientHelpers.getHttpConfigurable().PROXY_AUTHENTICATION;
    }

    @NotNull
    private static String getProxyHost() {
        return StringUtil.notNullize((String)IdeHttpClientHelpers.getHttpConfigurable().PROXY_HOST);
    }

    private static int getProxyPort() {
        return IdeHttpClientHelpers.getHttpConfigurable().PROXY_PORT;
    }

    @NotNull
    private static String getProxyLogin() {
        return StringUtil.notNullize((String)IdeHttpClientHelpers.getHttpConfigurable().getProxyLogin());
    }

    @NotNull
    private static String getProxyPassword() {
        return StringUtil.notNullize((String)IdeHttpClientHelpers.getHttpConfigurable().getPlainProxyPassword());
    }

    public static final class ApacheHttpClient4 {
        public static void setProxyIfEnabled(@NotNull RequestConfig.Builder builder) {
            if (IdeHttpClientHelpers.isHttpProxyEnabled()) {
                builder.setProxy(new HttpHost(IdeHttpClientHelpers.getProxyHost(), IdeHttpClientHelpers.getProxyPort()));
            }
        }

        public static void setProxyCredentialsIfEnabled(@NotNull CredentialsProvider provider2) {
            if (IdeHttpClientHelpers.isHttpProxyEnabled() && IdeHttpClientHelpers.isProxyAuthenticationEnabled()) {
                String ntlmUserPassword = IdeHttpClientHelpers.getProxyLogin().replace('\\', '/') + ":" + IdeHttpClientHelpers.getProxyPassword();
                provider2.setCredentials(new AuthScope(IdeHttpClientHelpers.getProxyHost(), IdeHttpClientHelpers.getProxyPort(), AuthScope.ANY_REALM, "NTLM"), (Credentials)new NTCredentials(ntlmUserPassword));
                provider2.setCredentials(new AuthScope(IdeHttpClientHelpers.getProxyHost(), IdeHttpClientHelpers.getProxyPort()), (Credentials)new UsernamePasswordCredentials(IdeHttpClientHelpers.getProxyLogin(), IdeHttpClientHelpers.getProxyPassword()));
            }
        }

        public static void setProxyForUrlIfEnabled(@NotNull RequestConfig.Builder builder, @Nullable String url) {
            if (IdeHttpClientHelpers.getHttpConfigurable().isHttpProxyEnabledForUrl(url)) {
                ApacheHttpClient4.setProxyIfEnabled(builder);
            }
        }

        public static void setProxyCredentialsForUrlIfEnabled(@NotNull CredentialsProvider provider2, @Nullable String url) {
            if (IdeHttpClientHelpers.getHttpConfigurable().isHttpProxyEnabledForUrl(url)) {
                ApacheHttpClient4.setProxyCredentialsIfEnabled(provider2);
            }
        }
    }
}

