/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.textCompletion.TextCompletionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextCompletionUtil {
    public static final Key<TextCompletionProvider> COMPLETING_TEXT_FIELD_KEY = Key.create((String)"COMPLETING_TEXT_FIELD_KEY");
    public static final Key<Boolean> AUTO_POPUP_KEY = Key.create((String)"AUTOPOPUP_TEXT_FIELD_KEY");

    public static void installProvider(@NotNull PsiFile psiFile, @NotNull TextCompletionProvider provider2, boolean autoPopup) {
        psiFile.putUserData(COMPLETING_TEXT_FIELD_KEY, (Object)provider2);
        psiFile.putUserData(AUTO_POPUP_KEY, (Object)autoPopup);
    }

    @Nullable
    public static TextCompletionProvider getProvider(@NotNull PsiFile file2) {
        TextCompletionProvider provider2 = (TextCompletionProvider)file2.getUserData(COMPLETING_TEXT_FIELD_KEY);
        if (provider2 == null || DumbService.isDumb((Project)file2.getProject()) && !DumbService.isDumbAware((Object)provider2)) {
            return null;
        }
        return provider2;
    }

    public static void installCompletionHint(@NotNull EditorEx editor) {
        final String completionShortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
        if (!StringUtil.isEmpty((String)completionShortcutText)) {
            final Ref toShowHintRef = new Ref((Object)true);
            editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    toShowHintRef.set((Object)false);
                }
            });
            editor.addFocusListener(new FocusChangeListener(){

                @Override
                public void focusGained(Editor editor) {
                    if (((Boolean)toShowHintRef.get()).booleanValue() && editor.getDocument().getText().isEmpty()) {
                        ApplicationManager.getApplication().invokeLater(() -> HintManager.getInstance().showInformationHint(editor, "Code completion available ( " + completionShortcutText + " )"));
                    }
                }

                @Override
                public void focusLost(Editor editor) {
                }
            });
        }
    }

    public static class DocumentWithCompletionCreator
    extends LanguageTextField.SimpleDocumentCreator {
        @NotNull
        private final TextCompletionProvider myProvider;
        private final boolean myAutoPopup;

        public DocumentWithCompletionCreator(@NotNull TextCompletionProvider provider2, boolean autoPopup) {
            this.myProvider = provider2;
            this.myAutoPopup = autoPopup;
        }

        @Override
        public void customizePsiFile(@NotNull PsiFile file2) {
            TextCompletionUtil.installProvider(file2, this.myProvider, this.myAutoPopup);
        }
    }
}

