/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.LanguageTextField;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithCompletion
extends LanguageTextField {
    private final boolean myForceAutoPopup;
    private final boolean myShowHint;

    public TextFieldWithCompletion(@NotNull Project project2, @NotNull TextCompletionProvider provider2, @NotNull String value2, boolean oneLineMode, boolean forceAutoPopup, boolean showHint2) {
        this(project2, provider2, value2, oneLineMode, true, forceAutoPopup, showHint2);
    }

    public TextFieldWithCompletion(@Nullable Project project2, @NotNull TextCompletionProvider provider2, @NotNull String value2, boolean oneLineMode, boolean autoPopup, boolean forceAutoPopup, boolean showHint2) {
        super(PlainTextLanguage.INSTANCE, project2, value2, new TextCompletionUtil.DocumentWithCompletionCreator(provider2, autoPopup), oneLineMode);
        this.myForceAutoPopup = forceAutoPopup;
        this.myShowHint = showHint2;
    }

    @Override
    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        EditorCustomization disableSpellChecking = SpellCheckingEditorCustomizationProvider.getInstance().getDisabledCustomization();
        if (disableSpellChecking != null) {
            disableSpellChecking.customize(editor);
        }
        editor.putUserData(AutoPopupController.ALWAYS_AUTO_POPUP, this.myForceAutoPopup);
        if (this.myShowHint) {
            TextCompletionUtil.installCompletionHint(editor);
        }
        return editor;
    }
}

