/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Getter;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.SwingHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public interface ReadonlyFieldWithHistoryWithBrowseButton {
    public JComponent getComponent();

    public void set(@NotNull String var1);

    @NotNull
    public String get();

    public void addListener(Runnable var1);

    public void setPreferredWidthToFitText();

    public static class Builder {
        private BiFunction<ActionEvent, String, String> myActionListener;
        private Getter<List<String>> myHistoryProvider;
        private Convertor<TextFieldWithHistory, ListCellRenderer> myRendererCreator;

        public Builder withRenderer(@NotNull Convertor<TextFieldWithHistory, ListCellRenderer> convertor) {
            this.myRendererCreator = convertor;
            return this;
        }

        public Builder withHistoryProvider(@NotNull Getter<List<String>> provider2) {
            this.myHistoryProvider = provider2;
            return this;
        }

        public Builder withActionListener(@NotNull BiFunction<ActionEvent, String, String> listener2) {
            this.myActionListener = listener2;
            return this;
        }

        public ReadonlyFieldWithHistoryWithBrowseButton build() {
            ListCellRenderer renderer;
            TextFieldWithHistoryWithBrowseButton field = new TextFieldWithHistoryWithBrowseButton();
            final TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)field.getChildComponent();
            textFieldWithHistory.setHistorySize(-1);
            textFieldWithHistory.setMinimumAndPreferredWidth(0);
            textFieldWithHistory.setEditable(false);
            ReadonlyFieldWithHistoryWithBrowseButton wrapper = Builder.createReadonlyFieldWrapper(field);
            if (this.myActionListener != null) {
                field.getButton().addActionListener(e -> {
                    String value2 = this.myActionListener.apply(e, wrapper.get());
                    if (value2 != null) {
                        wrapper.set(value2);
                    }
                });
            }
            if (this.myHistoryProvider != null) {
                textFieldWithHistory.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        SwingHelper.setHistory(textFieldWithHistory, ContainerUtil.notNullize((List)((List)myHistoryProvider.get())), false);
                    }
                });
            }
            if (this.myRendererCreator != null && (renderer = (ListCellRenderer)this.myRendererCreator.convert((Object)textFieldWithHistory)) != null) {
                textFieldWithHistory.setRenderer(renderer);
            }
            return wrapper;
        }

        @NotNull
        public static ReadonlyFieldWithHistoryWithBrowseButton createReadonlyFieldWrapper(final TextFieldWithHistoryWithBrowseButton field) {
            return new ReadonlyFieldWithHistoryWithBrowseButton(){

                @Override
                public JComponent getComponent() {
                    return field;
                }

                @Override
                public void set(@NotNull String text) {
                    TextFieldWithHistory component = (TextFieldWithHistory)field.getChildComponent();
                    if (!component.getHistory().contains(text)) {
                        component.setTextAndAddToHistory(text);
                    }
                    component.setSelectedItem((Object)text);
                }

                @Override
                @NotNull
                public String get() {
                    Object item = ((TextFieldWithHistory)field.getChildComponent()).getSelectedItem();
                    return item == null ? "" : item.toString().trim();
                }

                @Override
                public void addListener(final Runnable listener2) {
                    ((TextFieldWithHistory)field.getChildComponent()).addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            listener2.run();
                        }
                    });
                }

                @Override
                public void setPreferredWidthToFitText() {
                    SwingHelper.setPreferredWidthToFitText(field);
                }
            };
        }
    }
}

