/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReloadablePanel<T> {
    private static final String CONTROL_PLACE = "UI.Configuration.Component.Reload.Panel";
    private final AsyncProcessIcon myLoadingVersionIcon = new AsyncProcessIcon("Getting possible values");
    private final JLabel myErrorMessage = new JLabel();
    @Nullable
    private volatile DataProvider<T> myDataProvider;
    @Nullable
    private volatile UpdateStatus myUpdateStatus;
    protected JPanel myActionPanel;

    public ReloadablePanel() {
        this.myErrorMessage.setForeground((Color)JBColor.RED);
        this.createActionPanel();
        this.fillActionPanel();
    }

    private void createActionPanel() {
        this.myActionPanel = new JPanel(new CardLayout());
    }

    public final void setDataProvider(@NotNull DataProvider<T> dataProvider) {
        this.myDataProvider = dataProvider;
        Set<T> cachedValues = dataProvider.getCachedValues();
        if (cachedValues != null) {
            this.onUpdateValues(cachedValues);
        }
    }

    protected abstract void doUpdateValues(@NotNull Set<T> var1);

    public abstract T getSelectedValue();

    @NotNull
    public final JLabel getErrorComponent() {
        return this.myErrorMessage;
    }

    public final boolean isBackgroundJobRunning() {
        return this.myUpdateStatus == UpdateStatus.UPDATING;
    }

    public final void onUpdateValues(@NotNull Set<T> values) {
        this.changeUpdateStatus(UpdateStatus.IDLE);
        this.doUpdateValues(values);
    }

    public final void reloadValuesInBackground() {
        if (this.myUpdateStatus == UpdateStatus.UPDATING) {
            return;
        }
        this.changeUpdateStatus(UpdateStatus.UPDATING);
        this.myErrorMessage.setText(null);
        DataProvider<T> provider2 = this.myDataProvider;
        assert (provider2 != null);
        provider2.updateValuesAsynchronously();
    }

    private void changeUpdateStatus(@NotNull UpdateStatus status) {
        CardLayout cardLayout = (CardLayout)this.myActionPanel.getLayout();
        cardLayout.show(this.myActionPanel, status.name());
        if (status == UpdateStatus.UPDATING) {
            this.myLoadingVersionIcon.resume();
        } else {
            this.myLoadingVersionIcon.suspend();
        }
        this.myUpdateStatus = status;
    }

    protected void fillActionPanel() {
        this.myActionPanel.add((Component)this.createReloadButtonPanel(), UpdateStatus.IDLE.name());
        this.myActionPanel.add((Component)this.createReloadInProgressPanel(), UpdateStatus.UPDATING.name());
        this.changeUpdateStatus(UpdateStatus.IDLE);
    }

    public final void onValuesUpdateError(@NotNull String errorMessage) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.getSelectedValue() == null) {
                this.myErrorMessage.setText(errorMessage);
            }
            this.changeUpdateStatus(UpdateStatus.IDLE);
        });
    }

    @NotNull
    private JPanel createReloadButtonPanel() {
        ReloadAction reloadAction = new ReloadAction();
        ActionButton reloadButton = new ActionButton(reloadAction, reloadAction.getTemplatePresentation().clone(), CONTROL_PLACE, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        JPanel panel2 = new JPanel(new BorderLayout(0, 0));
        panel2.add((Component)reloadButton, "West");
        return panel2;
    }

    @NotNull
    public abstract JPanel getMainPanel();

    @NotNull
    JPanel getActionPanel() {
        return this.myActionPanel;
    }

    @NotNull
    private JPanel createReloadInProgressPanel() {
        JPanel panel2 = new JPanel();
        panel2.add((Component)this.myLoadingVersionIcon);
        return panel2;
    }

    private static enum UpdateStatus {
        UPDATING,
        IDLE;

    }

    private final class ReloadAction
    extends AnAction {
        private ReloadAction() {
            super("Reload list", null, AllIcons.Actions.Refresh);
        }

        public void actionPerformed(AnActionEvent e) {
            ReloadablePanel.this.reloadValuesInBackground();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }
    }

    public static interface DataProvider<T> {
        @Nullable
        public Set<T> getCachedValues();

        public void updateValuesAsynchronously();
    }
}

