/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ui.classpath.GlobalLibraryReferenceElement;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SingleRootClasspathElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleClasspathElementFactory {
    private SimpleClasspathElementFactory() {
    }

    public static List<SimpleClasspathElement> createElements(@Nullable Project project2, @NotNull Element element) {
        Library library;
        LibraryTable libraryTable;
        String name = element.getAttributeValue("name");
        String level = element.getAttributeValue("level");
        String url = element.getChildText("url");
        if (!StringUtil.isEmpty((String)url)) {
            return Collections.singletonList(new SingleRootClasspathElement(url));
        }
        if (name == null || level == null) {
            return Collections.emptyList();
        }
        if ("application".equals(level)) {
            return Collections.singletonList(new GlobalLibraryReferenceElement(name));
        }
        if (project2 != null && (libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, project2)) != null && (library = libraryTable.getLibraryByName(name)) != null) {
            return SimpleClasspathElementFactory.createElements(library);
        }
        return Collections.emptyList();
    }

    public static List<SimpleClasspathElement> createElements(@NotNull Library library) {
        LibraryTable table = library.getTable();
        if (table != null && "application".equals(table.getTableLevel())) {
            return Collections.singletonList(new GlobalLibraryReferenceElement(library.getName()));
        }
        ArrayList<SimpleClasspathElement> elements = new ArrayList<SimpleClasspathElement>();
        for (VirtualFile file2 : library.getFiles(OrderRootType.CLASSES)) {
            elements.add(new SingleRootClasspathElement(file2.getUrl()));
        }
        return elements;
    }

    public static List<SimpleClasspathElement> createElements(String ... urls) {
        ArrayList<SimpleClasspathElement> list = new ArrayList<SimpleClasspathElement>();
        for (String url : urls) {
            list.add(new SingleRootClasspathElement(url));
        }
        return list;
    }

    public static List<VirtualFile> convertToFiles(Collection<SimpleClasspathElement> cpeList) {
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (SimpleClasspathElement cpe : cpeList) {
            for (String fileUrl : cpe.getClassesRootUrls()) {
                VirtualFile file2 = fileManager.findFileByUrl(fileUrl);
                if (file2 == null) continue;
                files.add(file2);
            }
        }
        return files;
    }
}

