/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.CollectionModelEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.ComboBoxTableCellEditor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.TObjectObjectProcedure;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class TableModelEditor<T>
extends CollectionModelEditor<T, CollectionItemEditor<T>> {
    private final TableView<T> table;
    private final ToolbarDecorator toolbarDecorator;
    private final MyListTableModel model;

    public TableModelEditor(@NotNull ColumnInfo[] columns, @NotNull CollectionItemEditor<T> itemEditor, @NotNull String emptyText) {
        this(Collections.emptyList(), columns, itemEditor, emptyText);
    }

    public TableModelEditor(@NotNull List<T> items, @NotNull ColumnInfo[] columns, @NotNull CollectionItemEditor<T> itemEditor, @NotNull String emptyText) {
        super(itemEditor);
        this.model = new MyListTableModel(columns, new ArrayList<T>(items));
        this.table = new TableView((ListTableModel)this.model);
        this.table.setDefaultEditor(Enum.class, (TableCellEditor)ComboBoxTableCellEditor.INSTANCE);
        this.table.setStriped(true);
        this.table.setEnableAntialiasing(true);
        this.preferredScrollableViewportHeightInRows(7);
        new TableSpeedSearch((JTable)this.table);
        ColumnInfo firstColumn = columns[0];
        if ((firstColumn.getColumnClass() == Boolean.TYPE || firstColumn.getColumnClass() == Boolean.class) && firstColumn.getName().isEmpty()) {
            TableUtil.setupCheckboxColumn((TableColumn)this.table.getColumnModel().getColumn(0));
        }
        boolean needTableHeader = false;
        for (ColumnInfo column : columns) {
            if (StringUtil.isEmpty((String)column.getName())) continue;
            needTableHeader = true;
            break;
        }
        if (!needTableHeader) {
            this.table.setTableHeader(null);
        }
        this.table.getEmptyText().setText(emptyText);
        MyRemoveAction removeAction = new MyRemoveAction();
        this.toolbarDecorator = ToolbarDecorator.createDecorator(this.table, (ElementProducer)this).setRemoveAction((AnActionButtonRunnable)removeAction).setRemoveActionUpdater((AnActionButtonUpdater)removeAction);
        if (itemEditor instanceof DialogItemEditor) {
            this.addDialogActions();
        }
    }

    @NotNull
    public TableModelEditor<T> preferredScrollableViewportHeightInRows(int rows) {
        this.table.setPreferredScrollableViewportSize(new Dimension(200, this.table.getRowHeight() * rows));
        return this;
    }

    private void addDialogActions() {
        this.toolbarDecorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                Object item = TableModelEditor.this.table.getSelectedObject();
                if (item != null) {
                    Function mutator;
                    if (TableModelEditor.this.helper.isMutable(item)) {
                        mutator = FunctionUtil.id();
                    } else {
                        int selectedRow = TableModelEditor.this.table.getSelectedRow();
                        mutator = item12 -> TableModelEditor.this.helper.getMutable(item12, selectedRow);
                    }
                    ((DialogItemEditor)TableModelEditor.this.itemEditor).edit(item, mutator, false);
                    TableModelEditor.this.table.requestFocus();
                }
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                Object item = TableModelEditor.this.table.getSelectedObject();
                return item != null && ((DialogItemEditor)TableModelEditor.this.itemEditor).isEditable(item);
            }
        });
        if (((DialogItemEditor)this.itemEditor).isUseDialogToAdd()) {
            this.toolbarDecorator.setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    Object item = TableModelEditor.this.createElement();
                    ((DialogItemEditor)TableModelEditor.this.itemEditor).edit(item, item1 -> {
                        TableModelEditor.this.model.addRow(item1);
                        return item1;
                    }, true);
                }
            });
        }
    }

    @NotNull
    public TableModelEditor<T> disableUpDownActions() {
        this.toolbarDecorator.disableUpDownActions();
        return this;
    }

    @NotNull
    public TableModelEditor<T> enabled(boolean value2) {
        this.table.setEnabled(value2);
        return this;
    }

    public TableModelEditor<T> modelListener(@NotNull DataChangedListener<T> listener2) {
        this.model.dataChangedListener = listener2;
        this.model.addTableModelListener(listener2);
        return this;
    }

    @NotNull
    public ListTableModel<T> getModel() {
        return this.model;
    }

    @NotNull
    public static <T> T cloneUsingXmlSerialization(@NotNull T oldItem, @NotNull T newItem) {
        Element serialized = XmlSerializer.serialize(oldItem, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (!JDOMUtil.isEmpty((Element)serialized)) {
            XmlSerializer.deserializeInto(newItem, (Element)serialized);
        }
        return newItem;
    }

    @NotNull
    public JComponent createComponent() {
        return this.toolbarDecorator.addExtraAction((AnActionButton)new ToolbarDecorator.ElementActionButton(IdeBundle.message((String)"button.copy", (Object[])new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                TableUtil.stopEditing((JTable)TableModelEditor.this.table);
                List selectedItems = TableModelEditor.this.table.getSelectedObjects();
                if (selectedItems.isEmpty()) {
                    return;
                }
                for (Object item : selectedItems) {
                    TableModelEditor.this.model.addRow(TableModelEditor.this.itemEditor.clone(item, false));
                }
                TableModelEditor.this.table.requestFocus();
                TableUtil.updateScroller((JTable)TableModelEditor.this.table);
            }
        }).createPanel();
    }

    @Override
    @NotNull
    protected List<T> getItems() {
        return this.model.items;
    }

    public void selectItem(final @NotNull T item) {
        Ref ref;
        this.table.clearSelection();
        if (this.helper.hasModifiedItems()) {
            ref = Ref.create();
            this.helper.process(new TObjectObjectProcedure<T, T>(){

                public boolean execute(T modified, T original) {
                    if (item == original) {
                        ref.set(modified);
                    }
                    return ref.isNull();
                }
            });
        } else {
            ref = null;
        }
        this.table.addSelection(ref == null || ref.isNull() ? item : ref.get());
    }

    @NotNull
    public List<T> apply() {
        if (this.helper.hasModifiedItems()) {
            final ColumnInfo[] columns = this.model.getColumnInfos();
            this.helper.process(new TObjectObjectProcedure<T, T>(){

                public boolean execute(T newItem, @NotNull T oldItem) {
                    for (ColumnInfo column : columns) {
                        if (!column.isCellEditable(newItem)) continue;
                        column.setValue(oldItem, column.valueOf(newItem));
                    }
                    if (TableModelEditor.this.itemEditor instanceof DialogItemEditor) {
                        ((DialogItemEditor)TableModelEditor.this.itemEditor).applyEdited(oldItem, newItem);
                    }
                    TableModelEditor.this.model.items.set(ContainerUtil.indexOfIdentity((List)TableModelEditor.this.model.items, newItem), oldItem);
                    return true;
                }
            });
        }
        this.helper.reset(this.model.items);
        return this.model.items;
    }

    @Override
    public void reset(@NotNull List<T> items) {
        super.reset(items);
        this.model.setItems(new ArrayList<T>(items));
    }

    private class MyRemoveAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater,
    TableUtil.ItemChecker {
        private MyRemoveAction() {
        }

        public void run(AnActionButton button) {
            if (TableUtil.doRemoveSelectedItems((JTable)TableModelEditor.this.table, (ItemRemovable)TableModelEditor.this.model, (TableUtil.ItemChecker)this)) {
                TableModelEditor.this.table.requestFocus();
                TableUtil.updateScroller((JTable)TableModelEditor.this.table);
            }
        }

        public boolean isOperationApplyable(@NotNull TableModel ignored, int row) {
            Object item = TableModelEditor.this.model.getItem(row);
            return item != null && TableModelEditor.this.itemEditor.isRemovable(item);
        }

        public boolean isEnabled(AnActionEvent e) {
            return TableModelEditor.this.areSelectedItemsRemovable(TableModelEditor.this.table.getSelectionModel());
        }
    }

    public static abstract class EditableColumnInfo<Item, Aspect>
    extends ColumnInfo<Item, Aspect> {
        public EditableColumnInfo(@NotNull String name) {
            super(name);
        }

        public EditableColumnInfo() {
            super("");
        }

        public boolean isCellEditable(Item item) {
            return true;
        }
    }

    private final class MyListTableModel
    extends ListTableModel<T> {
        private List<T> items;
        private DataChangedListener<T> dataChangedListener;

        public MyListTableModel(@NotNull ColumnInfo[] columns, List<T> items) {
            super(columns, items);
            this.items = items;
        }

        public void setItems(@NotNull List<T> items) {
            this.items = items;
            super.setItems(items);
        }

        public void removeRow(int index) {
            TableModelEditor.this.helper.remove(this.getItem(index));
            super.removeRow(index);
        }

        public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
            if (rowIndex < this.getRowCount()) {
                ColumnInfo column = this.getColumnInfos()[columnIndex];
                Object item = this.getItem(rowIndex);
                Object oldValue = column.valueOf(item);
                if (column.getColumnClass() == String.class ? !Comparing.strEqual((String)((String)oldValue), (String)((String)newValue)) : !Comparing.equal((Object)oldValue, (Object)newValue)) {
                    column.setValue(TableModelEditor.this.helper.getMutable(item, rowIndex), newValue);
                    if (this.dataChangedListener != null) {
                        this.dataChangedListener.dataChanged(column, rowIndex);
                    }
                }
            }
        }
    }

    public static interface DialogItemEditor<T>
    extends CollectionItemEditor<T> {
        public void edit(@NotNull T var1, @NotNull Function<T, T> var2, boolean var3);

        public void applyEdited(@NotNull T var1, @NotNull T var2);

        default public boolean isEditable(@NotNull T item) {
            return true;
        }

        default public boolean isUseDialogToAdd() {
            return false;
        }
    }

    public static abstract class DataChangedListener<T>
    implements TableModelListener {
        public abstract void dataChanged(@NotNull ColumnInfo<T, ?> var1, int var2);

        @Override
        public void tableChanged(@NotNull TableModelEvent e) {
        }
    }
}

