/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.LanguagePerFileMappings;
import com.intellij.lang.PerFileMappings;
import com.intellij.lang.PerFileMappingsBase;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Setter;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerFileConfigurableBase<T>
implements SearchableConfigurable,
Configurable.NoScroll {
    protected static final Key<String> DESCRIPTION = KeyWithDefaultValue.create((String)"DESCRIPTION", (Object)"");
    protected static final Key<String> TARGET_TITLE = KeyWithDefaultValue.create((String)"TARGET_TITLE", (Object)"Path");
    protected static final Key<String> MAPPING_TITLE = KeyWithDefaultValue.create((String)"MAPPING_TITLE", (Object)"Mapping");
    protected static final Key<String> EMPTY_TEXT = KeyWithDefaultValue.create((String)"EMPTY_TEXT", (Object)"New Mapping $addShortcut");
    protected static final Key<String> OVERRIDE_QUESTION = Key.create((String)"OVERRIDE_QUESTION");
    protected static final Key<String> OVERRIDE_TITLE = Key.create((String)"OVERRIDE_TITLE");
    protected static final Key<String> CLEAR_TEXT = KeyWithDefaultValue.create((String)"CLEAR_TEXT", (Object)"<Clear>");
    protected static final Key<String> NULL_TEXT = KeyWithDefaultValue.create((String)"NULL_TEXT", (Object)"<None>");
    protected static final Key<Boolean> ADD_PROJECT_MAPPING = KeyWithDefaultValue.create((String)"ADD_PROJECT_MAPPING", (Object)Boolean.TRUE);
    protected final Project myProject;
    protected final PerFileMappings<T> myMappings;
    private JPanel myPanel;
    private JBTable myTable;
    private MyModel<T> myModel;
    private final List<Runnable> myResetRunnables = ContainerUtil.newArrayList();
    private final Map<String, T> myDefaultVals = ContainerUtil.newHashMap();
    private final List<Trinity<String, Producer<T>, Consumer<T>>> myDefaultProps = ContainerUtil.newArrayList();
    private VirtualFile myFileToSelect;

    protected PerFileConfigurableBase(@NotNull Project project2, @NotNull PerFileMappings<T> mappings) {
        this.myProject = project2;
        this.myMappings = mappings;
    }

    @NotNull
    public String getId() {
        return this.getDisplayName();
    }

    @Nullable
    protected abstract <S> Object getParameter(@NotNull Key<S> var1);

    @NotNull
    protected List<Trinity<String, Producer<T>, Consumer<T>>> getDefaultMappings() {
        return ContainerUtil.emptyList();
    }

    protected boolean canRemoveTarget(@Nullable Object target) {
        return true;
    }

    protected boolean canEditTarget(@Nullable Object target, T value2) {
        return true;
    }

    protected T adjustChosenValue(@Nullable Object target, T chosen) {
        return chosen;
    }

    protected abstract void renderValue(@Nullable Object var1, @NotNull T var2, @NotNull ColoredTextContainer var3);

    protected void renderDefaultValue(@Nullable Object target, @NotNull ColoredTextContainer renderer) {
    }

    private <S> S param(@NotNull Key<S> key2) {
        Object o = this.getParameter(key2);
        if (o == null && key2 instanceof KeyWithDefaultValue) {
            return (S)((KeyWithDefaultValue)key2).getDefaultValue();
        }
        return (S)o;
    }

    @NotNull
    public JComponent createComponent() {
        this.myPanel = new JPanel(new BorderLayout());
        this.myModel = new MyModel(this.param(TARGET_TITLE), this.param(MAPPING_TITLE));
        this.myTable = new JBTable(this.myModel){

            public String getToolTipText(@NotNull MouseEvent event) {
                Point point = event.getPoint();
                int row = this.rowAtPoint(point);
                int col = this.columnAtPoint(point);
                if (row != -1 && col == 1) {
                    return PerFileConfigurableBase.this.getToolTipFor(this.getValueAt(this.convertRowIndexToModel(row), col));
                }
                return super.getToolTipText(event);
            }
        };
        this.setupPerFileTable();
        JPanel tablePanel = ToolbarDecorator.createDecorator((JTable)this.myTable).disableUpAction().disableDownAction().setAddAction(button -> this.doAddAction((AnActionButton)button)).setRemoveAction(button -> this.doRemoveAction((AnActionButton)button)).setEditAction(button -> this.doEditAction((AnActionButton)button)).setEditActionUpdater(e -> this.myTable.getSelectedRows().length > 0).createPanel();
        this.myTable.getEmptyText().setText(this.param(EMPTY_TEXT).replace("$addShortcut", KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD))));
        JBLabel label = new JBLabel(this.param(DESCRIPTION));
        label.setBorder(BorderFactory.createEmptyBorder(7, 20, 10, 0));
        label.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        JComponent north = this.createDefaultMappingComponent();
        if (north != null) {
            this.myPanel.add((Component)north, "North");
        }
        this.myPanel.add((Component)label, "South");
        this.myPanel.add((Component)tablePanel, "Center");
        return this.myPanel;
    }

    @Nullable
    protected String getToolTipFor(@Nullable T value2) {
        return null;
    }

    @Nullable
    protected JComponent createDefaultMappingComponent() {
        this.myDefaultProps.addAll(this.getDefaultMappings());
        if (this.myMappings instanceof LanguagePerFileMappings && this.param(ADD_PROJECT_MAPPING).booleanValue()) {
            this.myDefaultProps.add(Trinity.create((Object)("Project " + StringUtil.capitalize((String)this.param(MAPPING_TITLE))), () -> ((LanguagePerFileMappings)this.myMappings).getConfiguredMapping(null), o -> this.myMappings.setMapping(null, o)));
        }
        if (this.myDefaultProps.size() == 0) {
            return null;
        }
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints cons1 = new GridBagConstraints();
        cons1.fill = 2;
        cons1.weightx = 0.0;
        cons1.gridx = 0;
        cons1.insets = JBUI.insets((int)0, (int)0, (int)5, (int)10);
        GridBagConstraints cons2 = new GridBagConstraints();
        cons2.fill = 0;
        cons2.anchor = 17;
        cons2.weightx = 0.0;
        cons2.gridx = 1;
        cons2.insets = cons1.insets;
        panel2.add(Box.createGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        for (final Trinity<String, Producer<T>, Consumer<T>> prop : this.myDefaultProps) {
            this.myDefaultVals.put((String)prop.first, ((Producer)prop.second).produce());
            JPanel p = this.createActionPanel(null, new Value<T>(){

                @Override
                public void commit() {
                    PerFileConfigurableBase.this.myModel.fireTableDataChanged();
                }

                public T get() {
                    return PerFileConfigurableBase.this.myDefaultVals.get(prop.first);
                }

                public void set(T value2) {
                    PerFileConfigurableBase.this.myDefaultVals.put(prop.first, PerFileConfigurableBase.this.adjustChosenValue(null, value2));
                }
            });
            panel2.add((Component)new JBLabel((String)prop.first + ":"), cons1);
            panel2.add((Component)p, cons2);
        }
        return panel2;
    }

    private void doAddAction(@NotNull AnActionButton button) {
        int row;
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        Object selectedTarget = (row = this.myTable.getSelectedRow()) >= 0 ? this.myModel.data.get((int)this.myTable.convertRowIndexToModel((int)row)).first : null;
        VirtualFile toSelect = this.myFileToSelect != null ? this.myFileToSelect : (VirtualFile)ObjectUtils.tryCast(selectedTarget, VirtualFile.class);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, true, true);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, (Component)this.myTable, (VirtualFile)toSelect, this::doAddFiles);
    }

    private void doAddFiles(@NotNull List<VirtualFile> files) {
        HashSet chosen = ContainerUtil.newHashSet(files);
        if (chosen.isEmpty()) {
            return;
        }
        Set set2 = this.myModel.data.stream().map(o -> o.first).collect(Collectors.toSet());
        for (VirtualFile file2 : chosen) {
            if (!set2.add(file2)) continue;
            this.myModel.data.add(Pair.create((Object)file2, null));
        }
        this.myModel.fireTableDataChanged();
        TIntArrayList rowList = new TIntArrayList();
        int size = this.myModel.data.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!chosen.contains(this.myModel.data.get((int)i2).first)) continue;
            rowList.add(i2);
        }
        this.selectRows(rowList.toNativeArray(), true);
    }

    private void doRemoveAction(@NotNull AnActionButton button) {
        int toSelect;
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
        int[] rows = this.myTable.getSelectedRows();
        int firstRow = rows[0];
        Object[] keys = new Object[rows.length];
        for (int i2 = 0; i2 < rows.length; ++i2) {
            keys[i2] = this.myModel.data.get((int)this.myTable.convertRowIndexToModel((int)rows[i2])).first;
        }
        if (this.clearSubdirectoriesOnDemandOrCancel(true, keys) == 0 && (toSelect = Math.min(this.myModel.data.size() - 1, firstRow)) >= 0) {
            this.selectRows(new int[]{toSelect}, false);
        }
    }

    private void doEditAction(@NotNull AnActionButton button) {
        TableUtil.editCellAt((JTable)this.myTable, (int)this.myTable.getSelectedRow(), (int)1);
    }

    @Nullable
    public T getNewMapping(@Nullable VirtualFile file2) {
        for (Pair p : ContainerUtil.reverse(this.myModel.data)) {
            if (!this.keyMatches(p.first, file2, false) || p.second == null) continue;
            return (T)p.second;
        }
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)this.myProject);
        for (Trinity prop : ContainerUtil.reverse(this.myDefaultProps)) {
            T t;
            if ((!((String)prop.first).startsWith("Project ") || file2 == null || !index.isInContent(file2)) && !((String)prop.first).startsWith("Global ") || (t = this.myDefaultVals.get(prop.first)) == null) continue;
            return t;
        }
        return (T)this.myMappings.getDefaultMapping(file2);
    }

    private boolean keyMatches(@Nullable Object key2, @Nullable VirtualFile file2, boolean strict) {
        if (file2 == null) {
            return key2 == null;
        }
        if (key2 instanceof VirtualFile) {
            return VfsUtilCore.isAncestor((VirtualFile)((VirtualFile)key2), (VirtualFile)file2, (boolean)strict);
        }
        return key2 == null;
    }

    public boolean isModified() {
        for (Trinity<String, Producer<T>, Consumer<T>> prop : this.myDefaultProps) {
            if (Comparing.equal((Object)((Producer)prop.second).produce(), this.myDefaultVals.get(prop.first))) continue;
            return true;
        }
        Map oldMapping = this.myMappings.getMappings();
        Map<VirtualFile, T> newMapping = this.getNewMappings();
        return !newMapping.equals(oldMapping);
    }

    public void apply() throws ConfigurationException {
        this.myMappings.setMappings(this.getNewMappings());
        for (Trinity<String, Producer<T>, Consumer<T>> prop : this.myDefaultProps) {
            ((Consumer)prop.third).consume(this.myDefaultVals.get(prop.first));
        }
    }

    public void reset() {
        this.myModel.data.clear();
        for (Map.Entry entry : this.myMappings.getMappings().entrySet()) {
            if (this.myMappings instanceof LanguagePerFileMappings && entry.getKey() == null) continue;
            this.myModel.data.add(Pair.create(entry.getKey(), entry.getValue()));
        }
        for (Trinity trinity : this.myDefaultProps) {
            this.myDefaultVals.put((String)trinity.first, ((Producer)trinity.second).produce());
        }
        for (Runnable runnable2 : this.myResetRunnables) {
            runnable2.run();
        }
        int[] rows = this.myTable.getSelectedRows();
        this.myModel.fireTableDataChanged();
        this.selectRows(rows, false);
    }

    protected void selectRows(int[] rows, boolean convertModelRowsToView) {
        int[] viewRows;
        int[] nArray = viewRows = convertModelRowsToView ? new int[rows.length] : rows;
        if (convertModelRowsToView) {
            for (int i2 = 0; i2 < rows.length; ++i2) {
                viewRows[i2] = this.myTable.convertRowIndexToView(rows[i2]);
            }
        }
        TableUtil.selectRows((JTable)this.myTable, (int[])viewRows);
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
    }

    protected Map<VirtualFile, T> getNewMappings() {
        HashMap map2 = ContainerUtil.newHashMap();
        for (Pair p : this.myModel.data) {
            if (p.second == null) continue;
            map2.put((VirtualFile)p.first, p.second);
        }
        if (this.myMappings instanceof LanguagePerFileMappings) {
            for (Trinity prop : ContainerUtil.reverse(this.myDefaultProps)) {
                if (!((String)prop.first).startsWith("Project ")) continue;
                T t = this.myDefaultVals.get(prop.first);
                if (t == null) break;
                map2.put(null, t);
                break;
            }
        }
        return map2;
    }

    public void selectFile(@NotNull VirtualFile virtualFile) {
        this.selectFile(virtualFile, true);
    }

    public void selectFile(@NotNull VirtualFile virtualFile, boolean addIfMissing) {
        VirtualFile file2 = virtualFile instanceof VirtualFileWindow ? ((VirtualFileWindow)virtualFile).getDelegate() : virtualFile;
        int[] rows = this.findRow(file2, addIfMissing, false);
        if (rows.length == 0 && addIfMissing) {
            this.doAddFiles(Collections.singletonList(virtualFile));
        } else {
            this.selectRows(rows, true);
        }
        this.myFileToSelect = file2;
    }

    protected int[] findRow(VirtualFile file2, boolean strict, boolean all) {
        TIntArrayList rows = new TIntArrayList();
        List reversed = ContainerUtil.reverse(this.myModel.data);
        int size = reversed.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Pair p = (Pair)reversed.get(i2);
            if (!this.keyMatches(p.first, file2, strict)) continue;
            rows.add(size - i2 - 1);
            if (!all) break;
        }
        return rows.toNativeArray();
    }

    private static String keyToString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof VirtualFile) {
            return ((VirtualFile)o).getPath();
        }
        return String.valueOf(o);
    }

    private void setupPerFileTable() {
        this.myTable.setEnableAntialiasing(true);
        this.myTable.getSelectionModel().setSelectionMode(2);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.setShowGrid(false);
        this.myTable.getColumnModel().setColumnMargin(0);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        TableRowSorter<MyModel<T>> sorter = new TableRowSorter<MyModel<T>>(this.myModel);
        sorter.setStringConverter(new TableStringConverter(){
            final SimpleColoredText text = new SimpleColoredText();

            @Override
            public String toString(TableModel model, int row, int column) {
                this.text.clear();
                Pair pair = ((PerFileConfigurableBase)PerFileConfigurableBase.this).myModel.data.get(row);
                if (column == 0) {
                    PerFileConfigurableBase.this.renderTarget(pair.first, (ColoredTextContainer)this.text);
                } else if (pair.second != null) {
                    PerFileConfigurableBase.this.renderValue(pair.first, pair.second, (ColoredTextContainer)this.text);
                } else {
                    PerFileConfigurableBase.this.renderDefaultValue(pair.first, (ColoredTextContainer)this.text);
                }
                return StringUtil.toLowerCase((String)this.text.toString());
            }
        });
        sorter.setSortable(0, true);
        sorter.setSortable(1, true);
        sorter.setSortsOnUpdates(true);
        this.myTable.setRowSorter(sorter);
        this.myTable.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.ASCENDING)));
        new TableSpeedSearch((JTable)this.myTable, (Convertor<Object, String>)((Convertor)o -> PerFileConfigurableBase.keyToString(o)));
        FontMetrics metrics = this.myTable.getFontMetrics(this.myTable.getFont());
        int maxValueWidth = 2 * metrics.stringWidth(this.myTable.getModel().getColumnName(1));
        SimpleColoredText text = new SimpleColoredText();
        for (T t : this.getValueVariants(null)) {
            text.clear();
            this.renderValue(null, t, (ColoredTextContainer)text);
            maxValueWidth = Math.max(metrics.stringWidth(text.toString()), maxValueWidth);
        }
        if (maxValueWidth < 300) {
            this.myTable.getColumnModel().getColumn(1).setMinWidth(maxValueWidth);
            this.myTable.getColumnModel().getColumn(1).setMaxWidth(2 * maxValueWidth);
        }
        this.myTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column) {
                PerFileConfigurableBase.this.renderTarget(value2, (ColoredTextContainer)this);
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(JTable table, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column) {
                Pair p = ((PerFileConfigurableBase)PerFileConfigurableBase.this).myModel.data.get(PerFileConfigurableBase.this.myTable.convertRowIndexToModel(row));
                if (p.second != null) {
                    this.setTransparentIconBackground(true);
                    PerFileConfigurableBase.this.renderValue(p.first, p.second, (ColoredTextContainer)this);
                } else {
                    PerFileConfigurableBase.this.renderDefaultValue(p.first, (ColoredTextContainer)this);
                }
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            T editorValue;

            public Component getTableCellEditorComponent(JTable table, final Object value2, boolean isSelected, int row, final int column) {
                final int modelRow = PerFileConfigurableBase.this.myTable.convertRowIndexToModel(row);
                final Pair pair = ((PerFileConfigurableBase)PerFileConfigurableBase.this).myModel.data.get(modelRow);
                final Object target = pair.first;
                this.editorValue = pair.second;
                if (!PerFileConfigurableBase.this.canEditTarget(target, this.editorValue)) {
                    return null;
                }
                JPanel panel2 = PerFileConfigurableBase.this.createActionPanel(target, new Value<T>(){

                    public T get() {
                        return editorValue;
                    }

                    public void set(T value22) {
                        editorValue = PerFileConfigurableBase.this.adjustChosenValue(target, value22);
                    }

                    @Override
                    public void commit() {
                        TableUtil.stopEditing((JTable)PerFileConfigurableBase.this.myTable);
                        PerFileConfigurableBase.this.selectRows(new int[]{modelRow}, true);
                        if (!Comparing.equal(editorValue, (Object)pair.second)) {
                            int ret = PerFileConfigurableBase.this.clearSubdirectoriesOnDemandOrCancel(false, new Object[]{target});
                            if (ret == 2) {
                                PerFileConfigurableBase.this.myModel.setValueAt(value2, modelRow, column);
                            }
                            PerFileConfigurableBase.this.selectRows(new int[]{modelRow}, true);
                        }
                    }
                }, true);
                AbstractButton button = (AbstractButton)UIUtil.uiTraverser((Component)panel2).filter(JButton.class).first();
                if (button != null) {
                    AtomicInteger clickCount = new AtomicInteger();
                    button.addActionListener(e -> clickCount.incrementAndGet());
                    SwingUtilities.invokeLater(() -> {
                        if (clickCount.get() == 0 && PerFileConfigurableBase.this.myTable.getEditorComponent() == panel2) {
                            button.doClick();
                        }
                    });
                }
                return panel2;
            }

            public Object getCellEditorValue() {
                return this.editorValue;
            }
        });
    }

    @NotNull
    protected JPanel createActionPanel(@Nullable Object target, @NotNull Value<T> value2) {
        return this.createActionPanel(target, value2, false);
    }

    @NotNull
    private JPanel createActionPanel(@Nullable Object target, @NotNull Value<T> value2, boolean editor) {
        AnAction changeAction = this.createValueAction(target, value2);
        JComponent comboComponent = ((CustomComponentAction)changeAction).createCustomComponent(changeAction.getTemplatePresentation());
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public Color getBackground() {
                Container parent = this.getParent();
                return parent instanceof JTable ? ((JTable)parent).getSelectionBackground() : super.getBackground();
            }
        };
        panel2.add((Component)comboComponent, "Center");
        comboComponent.setOpaque(false);
        DataContext dataContext = SimpleDataContext.getProjectContext(this.myProject);
        AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)changeAction, null, (String)"unknown", (DataContext)dataContext);
        changeAction.update(event);
        panel2.revalidate();
        if (!editor) {
            this.myResetRunnables.add(() -> changeAction.update(null));
        }
        return panel2;
    }

    private int clearSubdirectoriesOnDemandOrCancel(boolean keysToo, Object ... keys) {
        int ret;
        TIntArrayList rows = new TIntArrayList();
        boolean toOverride = false;
        int size = this.myModel.data.size();
        block0: for (int i2 = 0; i2 < size; ++i2) {
            Pair p = this.myModel.data.get(i2);
            if (!(p.first instanceof VirtualFile)) continue;
            Object[] objectArray = keys;
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                Object key2 = objectArray[j];
                if (key2 == p.first) {
                    if (!keysToo) continue block0;
                    rows.add(-i2 - 1);
                    continue block0;
                }
                if (!this.keyMatches(key2, (VirtualFile)p.first, true)) continue;
                toOverride = true;
                rows.add(i2);
                continue block0;
            }
        }
        int n = ret = !toOverride ? 1 : this.askUserToOverrideSubdirectories();
        if (ret == 2) {
            return ret;
        }
        int count = 0;
        for (int i3 : rows.toNativeArray()) {
            if (i3 >= 0 && ret == 1) continue;
            int index = (i3 >= 0 ? i3 : -i3 - 1) - count;
            if (this.canRemoveTarget(this.myModel.data.get((int)index).first)) {
                this.myModel.data.remove(index);
                ++count;
                continue;
            }
            this.myModel.data.set(index, Pair.create((Object)this.myModel.data.get((int)0).first, null));
        }
        if (!rows.isEmpty()) {
            this.myModel.fireTableDataChanged();
        }
        return ret;
    }

    private int askUserToOverrideSubdirectories() {
        String question = this.param(OVERRIDE_QUESTION);
        String title = this.param(OVERRIDE_TITLE);
        if (question == null || title == null) {
            return 1;
        }
        return Messages.showYesNoCancelDialog((Project)this.myProject, (String)question, (String)title, (String)"Override", (String)"Do Not Override", (String)"Cancel", (Icon)Messages.getWarningIcon());
    }

    private String renderValue(@Nullable Object value2, @NotNull String nullValue) {
        if (value2 == null) {
            return nullValue;
        }
        SimpleColoredText text = new SimpleColoredText();
        this.renderValue(null, value2, (ColoredTextContainer)text);
        return text.toString();
    }

    protected void renderTarget(@Nullable Object target, @NotNull ColoredTextContainer renderer) {
        VirtualFile file2;
        VirtualFile virtualFile = file2 = target instanceof VirtualFile ? (VirtualFile)target : null;
        if (file2 != null) {
            renderer.setIcon(IconUtil.getIcon((VirtualFile)file2, (int)2, (Project)this.myProject));
            VirtualFile parent = file2.getParent();
            if (parent != null) {
                String parentPath = FileUtil.toSystemDependentName((String)parent.getPath());
                renderer.append(parentPath, SimpleTextAttributes.GRAY_ATTRIBUTES);
                if (!parentPath.endsWith(File.separator)) {
                    renderer.append(File.separator, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }
            renderer.append(file2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (target == null) {
            renderer.append("Project", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @NotNull
    protected final AnAction createValueAction(final @Nullable Object target, final @NotNull Value<T> value2) {
        return new ComboBoxAction(){

            void updateText() {
                String text = PerFileConfigurableBase.this.renderValue(value2.get(), StringUtil.notNullize((String)PerFileConfigurableBase.this.getNullValueText(target)));
                this.getTemplatePresentation().setText(StringUtil.shortenTextWithEllipsis((String)text, (int)40, (int)0));
            }

            public void update(AnActionEvent e) {
                this.updateText();
            }

            @NotNull
            protected DefaultActionGroup createPopupActionGroup(JComponent button) {
                throw new UnsupportedOperationException();
            }

            protected ComboBoxAction.ComboBoxButton createComboBoxButton(Presentation presentation) {
                return new ComboBoxAction.ComboBoxButton(presentation){

                    protected JBPopup createPopup(Runnable onDispose) {
                        JBPopup popup = PerFileConfigurableBase.this.createValueEditorPopup(target, value2.get(), onDispose, this.getDataContext(), o -> {
                            value2.set(o);
                            this.updateText();
                        }, value2::commit);
                        popup.setMinimumSize(new Dimension(this.getMinWidth(), this.getMinHeight()));
                        return popup;
                    }

                    @Nullable
                    public String getToolTipText() {
                        boolean cellEditor = UIUtil.uiParents((Component)((Object)this), (boolean)true).take(4).filter(JBTable.class).first() != null;
                        return cellEditor ? null : PerFileConfigurableBase.this.getToolTipFor(value2.get());
                    }
                };
            }
        };
    }

    @NotNull
    protected JBPopup createValueEditorPopup(@Nullable Object target, @Nullable T value2, @Nullable Runnable onDispose, @NotNull DataContext dataContext, @NotNull Consumer<T> onChosen, @NotNull Runnable onCommit) {
        return this.createValueEditorActionListPopup(target, onDispose, dataContext, chosen -> {
            onChosen.consume(chosen);
            onCommit.run();
        });
    }

    @NotNull
    protected final JBPopup createValueEditorActionListPopup(@Nullable Object target, @Nullable Runnable onDispose, @NotNull DataContext dataContext, @NotNull Consumer<T> onChosen) {
        ActionGroup group = this.createActionListGroup(target, onChosen);
        return JBPopupFactory.getInstance().createActionGroupPopup(null, group, dataContext, false, false, false, onDispose, 30, null);
    }

    @Nullable
    protected Icon getActionListIcon(@Nullable Object target, T t) {
        return null;
    }

    @Nullable
    protected String getClearValueText(@Nullable Object target) {
        return target == null ? this.getNullValueText(null) : this.param(CLEAR_TEXT);
    }

    @Nullable
    protected String getNullValueText(@Nullable Object target) {
        return this.param(NULL_TEXT);
    }

    @NotNull
    protected Collection<T> getValueVariants(@Nullable Object target) {
        if (this.myMappings instanceof PerFileMappingsBase) {
            return ((PerFileMappingsBase)this.myMappings).getAvailableValues();
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected ActionGroup createActionListGroup(@Nullable Object target, final @NotNull Consumer<T> onChosen) {
        DefaultActionGroup group = new DefaultActionGroup();
        String clearText = this.getClearValueText(target);
        Function choseAction = t -> {
            String nullValue = StringUtil.notNullize((String)clearText);
            DumbAwareAction a = new DumbAwareAction(this.renderValue(t, nullValue), "", this.getActionListIcon(target, t)){

                public void actionPerformed(AnActionEvent e) {
                    onChosen.consume(t);
                }
            };
            a.getTemplatePresentation().setText(this.renderValue(t, nullValue));
            return a;
        };
        if (clearText != null) {
            group.add((AnAction)choseAction.fun(null));
        }
        SimpleColoredText text = new SimpleColoredText();
        ArrayList<T> values = new ArrayList<T>(this.getValueVariants(target));
        Function toString = o -> {
            text.clear();
            this.renderValue(target, o, (ColoredTextContainer)text);
            return text.toString();
        };
        Collections.sort(values, (o1, o2) -> StringUtil.naturalCompare((String)((String)toString.fun(o1)), (String)((String)toString.fun(o2))));
        for (Object t2 : values) {
            group.add((AnAction)choseAction.fun(t2));
        }
        return group;
    }

    private static class MyModel<T>
    extends AbstractTableModel {
        final String[] columnNames;
        final List<Pair<Object, T>> data = ContainerUtil.newArrayList();

        public MyModel(String ... names) {
            this.columnNames = names;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex > 0;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? this.data.get((int)rowIndex).first : this.data.get((int)rowIndex).second;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Pair<Object, T> pair = this.data.get(rowIndex);
            if (Comparing.equal((Object)aValue, (Object)pair.second)) {
                return;
            }
            this.data.set(rowIndex, Pair.create((Object)pair.first, (Object)aValue));
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        @Override
        public void fireTableDataChanged() {
            Collections.sort(this.data, (o1, o2) -> StringUtil.naturalCompare((String)PerFileConfigurableBase.keyToString(o1.first), (String)PerFileConfigurableBase.keyToString(o2.first)));
            super.fireTableDataChanged();
        }
    }

    protected static interface Value<T>
    extends Setter<T>,
    Getter<T> {
        public void commit();
    }
}

