/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.project.Project;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomDeclarationSearcher
extends PomDeclarationSearcher {
    public void findDeclarationsAt(@NotNull PsiElement psiElement, int offsetInElement, Consumer<PomTarget> consumer2) {
        GenericAttributeValue nameElement;
        if (!(psiElement instanceof XmlToken)) {
            return;
        }
        IElementType tokenType = ((XmlToken)psiElement).getTokenType();
        DomManager domManager = DomManager.getDomManager((Project)psiElement.getProject());
        if (tokenType == XmlTokenType.XML_DATA_CHARACTERS && psiElement.getParent() instanceof XmlText && psiElement.getParent().getParent() instanceof XmlTag) {
            XmlTag tag = (XmlTag)psiElement.getParent().getParent();
            for (XmlText text : tag.getValue().getTextElements()) {
                if (!InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)text)) continue;
                return;
            }
            nameElement = domManager.getDomElement(tag);
        } else if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && psiElement.getParent() instanceof XmlAttributeValue && psiElement.getParent().getParent() instanceof XmlAttribute) {
            PsiElement attributeValue = psiElement.getParent();
            if (InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)attributeValue)) {
                return;
            }
            nameElement = domManager.getDomElement((XmlAttribute)attributeValue.getParent());
        } else {
            return;
        }
        if (!(nameElement instanceof GenericDomValue)) {
            return;
        }
        DomElement parent = nameElement.getParent();
        if (parent == null) {
            return;
        }
        DomTarget target = this.createDomTarget(parent, (DomElement)nameElement);
        if (target != null) {
            consumer2.consume((Object)target);
        }
    }

    @Nullable
    protected abstract DomTarget createDomTarget(DomElement var1, DomElement var2);
}

