/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.highlighting.DomCollectionProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptorImpl;
import com.intellij.util.xml.impl.ConvertContextFactory;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementAnnotationHolderImpl
extends SmartList<DomElementProblemDescriptor>
implements DomElementAnnotationHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl");
    private final SmartList<Annotation> myAnnotations = new SmartList();
    private final boolean myOnTheFly;

    public DomElementAnnotationHolderImpl(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @NotNull
    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, @Nullable String message2, LocalQuickFix ... fixes) {
        return this.createProblem(domElement, HighlightSeverity.ERROR, message2, fixes);
    }

    @NotNull
    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, DomCollectionChildDescription childDescription, @Nullable String message2) {
        return this.addProblem(new DomCollectionProblemDescriptorImpl(domElement, message2, HighlightSeverity.ERROR, childDescription));
    }

    @NotNull
    public final DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, String message2) {
        return this.createProblem(domElement, highlightType, message2, LocalQuickFix.EMPTY_ARRAY);
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, String message2, LocalQuickFix ... fixes) {
        return this.createProblem(domElement, highlightType, message2, (TextRange)null, fixes);
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, HighlightSeverity highlightType, String message2, TextRange textRange, LocalQuickFix ... fixes) {
        return this.addProblem(new DomElementProblemDescriptorImpl(domElement, message2, highlightType, textRange, null, fixes));
    }

    public DomElementProblemDescriptor createProblem(@NotNull DomElement domElement, ProblemHighlightType highlightType, String message2, @Nullable TextRange textRange, LocalQuickFix ... fixes) {
        return this.addProblem(new DomElementProblemDescriptorImpl(domElement, message2, HighlightSeverity.ERROR, textRange, highlightType, fixes));
    }

    @NotNull
    public DomElementResolveProblemDescriptor createResolveProblem(@NotNull GenericDomValue element, @NotNull PsiReference reference) {
        return this.addProblem(new DomElementResolveProblemDescriptorImpl(element, reference, this.getQuickFixes(element, reference)));
    }

    @NotNull
    public Annotation createAnnotation(@NotNull DomElement element, HighlightSeverity severity, @Nullable String message2) {
        XmlElement xmlElement = element.getXmlElement();
        LOG.assertTrue(xmlElement != null, (Object)("No XML element for " + element));
        TextRange range = xmlElement.getTextRange();
        int startOffset = range.getStartOffset();
        int endOffset = message2 == null ? startOffset : range.getEndOffset();
        Annotation annotation = new Annotation(startOffset, endOffset, severity, message2, null);
        this.myAnnotations.add((Object)annotation);
        return annotation;
    }

    public final SmartList<Annotation> getAnnotations() {
        return this.myAnnotations;
    }

    public int getSize() {
        return this.size();
    }

    private LocalQuickFix[] getQuickFixes(GenericDomValue element, PsiReference reference) {
        Object[] localQuickFixes;
        if (!this.myOnTheFly) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        Converter converter = WrappingConverter.getDeepestConverter((Converter)element.getConverter(), (GenericDomValue)element);
        if (converter instanceof ResolvingConverter) {
            ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
            ContainerUtil.addAll((Collection)result2, (Object[])resolvingConverter.getQuickFixes(ConvertContextFactory.createConvertContext(DomManagerImpl.getDomInvocationHandler((DomElement)element))));
        }
        if (reference instanceof LocalQuickFixProvider && (localQuickFixes = ((LocalQuickFixProvider)reference).getQuickFixes()) != null) {
            ContainerUtil.addAll((Collection)result2, (Object[])localQuickFixes);
        }
        return result2.isEmpty() ? LocalQuickFix.EMPTY_ARRAY : result2.toArray(new LocalQuickFix[result2.size()]);
    }

    public <T extends DomElementProblemDescriptor> T addProblem(T problemDescriptor) {
        this.add(problemDescriptor);
        return problemDescriptor;
    }
}

