/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import org.jetbrains.annotations.NotNull;

class DomElementResolveProblemDescriptorImpl
extends DomElementProblemDescriptorImpl
implements DomElementResolveProblemDescriptor {
    @NotNull
    private final PsiReference myReference;

    public DomElementResolveProblemDescriptorImpl(@NotNull GenericDomValue domElement, @NotNull PsiReference reference, LocalQuickFix ... quickFixes) {
        super((DomElement)domElement, reference instanceof FileReference ? ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference) : XmlHighlightVisitor.getErrorDescription(reference), HighlightSeverity.ERROR, quickFixes);
        this.myReference = reference;
    }

    @NotNull
    public PsiReference getPsiReference() {
        return this.myReference;
    }

    @NotNull
    public GenericDomValue getDomElement() {
        return (GenericDomValue)super.getDomElement();
    }

    @Override
    @NotNull
    protected Pair<TextRange, PsiElement> computeProblemRange() {
        PsiReference reference = this.myReference;
        PsiElement element = reference.getElement();
        if (element instanceof XmlAttributeValue && element.getTextLength() == 0) {
            return NO_PROBLEM;
        }
        TextRange referenceRange = reference.getRangeInElement();
        if (referenceRange.isEmpty()) {
            int startOffset = referenceRange.getStartOffset();
            return element instanceof XmlAttributeValue ? Pair.create((Object)new UnfairTextRange(startOffset - 1, startOffset + 1), (Object)element) : Pair.create((Object)TextRange.from((int)startOffset, (int)1), (Object)element);
        }
        return Pair.create((Object)referenceRange, (Object)element);
    }
}

