/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomChangeAdapter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.highlighting.DomHighlightStatus;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.Highlightable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class DomElementsErrorPanel
extends JPanel
implements CommittablePanel,
Highlightable {
    private static final int ALARM_PERIOD = 241;
    private final Project myProject;
    private final DomElement[] myDomElements;
    private final DomElementsTrafficLightRenderer myErrorStripeRenderer;
    private final DomElementAnnotationsManagerImpl myAnnotationsManager;
    private final Alarm myAlarm = new Alarm();

    public DomElementsErrorPanel(DomElement ... domElements) {
        assert (domElements.length > 0);
        this.myDomElements = domElements;
        DomManager domManager = domElements[0].getManager();
        this.myProject = domManager.getProject();
        this.myAnnotationsManager = (DomElementAnnotationsManagerImpl)DomElementAnnotationsManager.getInstance((Project)this.myProject);
        this.setPreferredSize(DomElementsErrorPanel.getDimension());
        this.myErrorStripeRenderer = new DomElementsTrafficLightRenderer(DomUtil.getFile((DomElement)domElements[0]));
        Disposer.register((Disposable)this, (Disposable)this.myErrorStripeRenderer);
        this.addUpdateRequest();
        domManager.addDomEventListener((DomEventListener)new DomChangeAdapter(){

            protected void elementChanged(DomElement element) {
                DomElementsErrorPanel.this.addUpdateRequest();
            }
        }, (Disposable)this);
    }

    public void updateHighlighting() {
        this.updatePanel();
    }

    private boolean areValid() {
        for (DomElement domElement : this.myDomElements) {
            if (domElement.isValid()) continue;
            return false;
        }
        return true;
    }

    private void updatePanel() {
        this.myAlarm.cancelAllRequests();
        if (!this.areValid()) {
            return;
        }
        this.repaint();
        this.setToolTipText(this.myErrorStripeRenderer.getTooltipMessage());
        if (!this.isHighlightingFinished()) {
            this.addUpdateRequest();
        }
    }

    private boolean isHighlightingFinished() {
        return !this.areValid() || this.myAnnotationsManager.isHighlightingFinished(this.myDomElements);
    }

    private void addUpdateRequest() {
        ApplicationManager.getApplication().invokeLater(() -> this.myAlarm.addRequest(() -> {
            if (this.myProject.isOpen() && !this.myProject.isDisposed()) {
                this.updatePanel();
            }
        }, 241));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.myErrorStripeRenderer.paint(this, g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public void dispose() {
        this.myAlarm.cancelAllRequests();
    }

    public JComponent getComponent() {
        return this;
    }

    public void commit() {
    }

    public void reset() {
        this.updatePanel();
    }

    private static Dimension getDimension() {
        return new Dimension(AllIcons.General.ErrorsInProgress.getIconWidth() + 2, AllIcons.General.ErrorsInProgress.getIconHeight() + 2);
    }

    private class DomElementsTrafficLightRenderer
    extends TrafficLightRenderer {
        public DomElementsTrafficLightRenderer(XmlFile xmlFile) {
            super(xmlFile.getProject(), PsiDocumentManager.getInstance((Project)xmlFile.getProject()).getDocument((PsiFile)xmlFile), (PsiFile)xmlFile);
        }

        @Override
        @NotNull
        protected TrafficLightRenderer.DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
            TrafficLightRenderer.DaemonCodeAnalyzerStatus status = super.getDaemonCodeAnalyzerStatus(severityRegistrar);
            if (this.isInspectionCompleted()) {
                status.errorAnalyzingFinished = true;
            }
            return status;
        }

        @Override
        protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull TrafficLightRenderer.DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
            for (int i2 = 0; i2 < status.errorCount.length; ++i2) {
                HighlightSeverity minSeverity = severityRegistrar.getSeverityByIndex(i2);
                if (minSeverity == null) continue;
                int sum = 0;
                for (DomElement element : DomElementsErrorPanel.this.myDomElements) {
                    DomElementsProblemsHolder holder = DomElementsErrorPanel.this.myAnnotationsManager.getCachedProblemHolder(element);
                    sum += (SeverityRegistrar.getSeverityRegistrar(this.getProject()).compare(minSeverity, HighlightSeverity.WARNING) >= 0 ? holder.getProblems(element, true, true) : holder.getProblems(element, true, minSeverity)).size();
                }
                status.errorCount[i2] = sum;
            }
        }

        protected boolean isInspectionCompleted() {
            return ContainerUtil.and((Object[])DomElementsErrorPanel.this.myDomElements, element -> DomElementsErrorPanel.this.myAnnotationsManager.getHighlightStatus((DomElement)element) == DomHighlightStatus.INSPECTIONS_FINISHED);
        }

        protected boolean isErrorAnalyzingFinished() {
            return ContainerUtil.and((Object[])DomElementsErrorPanel.this.myDomElements, element -> DomElementsErrorPanel.this.myAnnotationsManager.getHighlightStatus((DomElement)element).compareTo(DomHighlightStatus.ANNOTATORS_FINISHED) >= 0);
        }
    }
}

