/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.RootDomParentStrategy;
import com.intellij.util.xml.stubs.ElementStub;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomRootInvocationHandler
extends DomInvocationHandler<AbstractDomChildDescriptionImpl, ElementStub> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomRootInvocationHandler");
    private final DomFileElementImpl<?> myParent;

    public DomRootInvocationHandler(Class aClass, RootDomParentStrategy strategy, @NotNull DomFileElementImpl fileElement, @NotNull EvaluatedXmlName tagName, @Nullable ElementStub stub) {
        super(aClass, strategy, tagName, new AbstractDomChildDescriptionImpl(aClass){

            @NotNull
            public List<? extends DomElement> getValues(@NotNull DomElement parent) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int compareTo(AbstractDomChildDescriptionImpl o) {
                throw new UnsupportedOperationException();
            }
        }, fileElement.getManager(), true, stub);
        this.myParent = fileElement;
    }

    @Override
    public void undefineInternal() {
        try {
            XmlTag tag = this.getXmlTag();
            if (tag != null) {
                this.deleteTag(tag);
                this.detach();
                this.fireUndefinedEvent();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DomRootInvocationHandler)) {
            return false;
        }
        DomRootInvocationHandler handler2 = (DomRootInvocationHandler)((Object)obj);
        return this.myParent.equals(handler2.myParent);
    }

    @Override
    public int hashCode() {
        return this.myParent.hashCode();
    }

    @Override
    public boolean exists() {
        return this.getStub() != null || this.getXmlElement() != null;
    }

    @Override
    @NotNull
    public String getXmlElementNamespace() {
        return this.getXmlName().getNamespace((XmlElement)this.getFile(), this.getFile());
    }

    @Override
    protected String checkValidity() {
        XmlTag tag = (XmlTag)this.getXmlElement();
        if (tag != null && !tag.isValid()) {
            return "invalid root tag";
        }
        String s = this.myParent.checkValidity();
        if (s != null) {
            return "root: " + s;
        }
        return null;
    }

    @NotNull
    public DomFileElementImpl getParent() {
        return this.myParent;
    }

    @Override
    public DomElement createPathStableCopy() {
        DomFileElement stableCopy = (DomFileElement)this.myParent.createStableCopy();
        return this.getManager().createStableValue(() -> stableCopy.isValid() ? stableCopy.getRootElement() : null);
    }

    @Override
    protected XmlTag setEmptyXmlTag() {
        XmlTag[] result2 = new XmlTag[]{null};
        this.getManager().runChange(() -> {
            try {
                String namespace = this.getXmlElementNamespace();
                String nsDecl = StringUtil.isEmpty((String)namespace) ? "" : " xmlns=\"" + namespace + "\"";
                XmlFile xmlFile = this.getFile();
                XmlTag tag = XmlElementFactory.getInstance((Project)xmlFile.getProject()).createTagFromText((CharSequence)("<" + this.getXmlElementName() + nsDecl + "/>"));
                result2[0] = ((XmlDocument)xmlFile.getDocument().replace((PsiElement)((XmlFile)tag.getContainingFile()).getDocument())).getRootTag();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
        return result2[0];
    }

    @Override
    @NotNull
    public final DomNameStrategy getNameStrategy() {
        Class<?> rawType = this.getRawType();
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(rawType, this.isAttribute());
        if (strategy != null) {
            return strategy;
        }
        return DomNameStrategy.HYPHEN_STRATEGY;
    }
}

