/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomFileIndex;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomAnchorImpl;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.structure.DomStructureViewBuilder;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomServiceImpl
extends DomService {
    private static final Key<CachedValue<XmlFileHeader>> ROOT_TAG_NS_KEY = Key.create((String)"rootTag&ns");
    private static final UserDataCache<CachedValue<XmlFileHeader>, XmlFile, Object> ourRootTagCache = new UserDataCache<CachedValue<XmlFileHeader>, XmlFile, Object>(){

        protected CachedValue<XmlFileHeader> compute(XmlFile file2, Object o) {
            return CachedValuesManager.getManager((Project)file2.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)DomServiceImpl.calcXmlFileHeader(file2), new Object[]{file2}), false);
        }
    };

    @NotNull
    private static XmlFileHeader calcXmlFileHeader(XmlFile file2) {
        Stub root;
        ObjectStubTree tree;
        VirtualFile virtualFile;
        if (file2 instanceof PsiFileEx && ((PsiFileEx)file2).isContentsLoaded() && file2.getNode().isParsed()) {
            return DomServiceImpl.computeHeaderByPsi(file2);
        }
        if (!XmlUtil.isStubBuilding() && file2.getFileType() == XmlFileType.INSTANCE && (virtualFile = file2.getVirtualFile()) instanceof VirtualFileWithId && (tree = StubTreeLoader.getInstance().readFromVFile(file2.getProject(), virtualFile)) != null && (root = tree.getRoot()) instanceof FileStub) {
            return ((FileStub)root).getHeader();
        }
        if (!file2.isValid()) {
            return XmlFileHeader.EMPTY;
        }
        return NanoXmlUtil.parseHeader((PsiFile)file2);
    }

    private static XmlFileHeader computeHeaderByPsi(XmlFile file2) {
        XmlTag tag;
        XmlDoctype doctype;
        XmlDocument document = file2.getDocument();
        if (document == null) {
            return XmlFileHeader.EMPTY;
        }
        String publicId = null;
        String systemId = null;
        XmlProlog prolog = document.getProlog();
        if (prolog != null && (doctype = prolog.getDoctype()) != null) {
            publicId = doctype.getPublicId();
            systemId = doctype.getSystemId();
            if (systemId == null) {
                systemId = doctype.getDtdUri();
            }
        }
        if ((tag = document.getRootTag()) == null) {
            return XmlFileHeader.EMPTY;
        }
        String localName = tag.getLocalName();
        if (StringUtil.isNotEmpty((String)localName)) {
            if (tag.getPrevSibling() instanceof PsiErrorElement) {
                return XmlFileHeader.EMPTY;
            }
            String psiNs = tag.getNamespace();
            return new XmlFileHeader(localName, psiNs == "" || Comparing.equal((String)psiNs, (String)systemId) ? null : psiNs, publicId, systemId);
        }
        return XmlFileHeader.EMPTY;
    }

    public ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    public <T extends DomElement> DomAnchor<T> createAnchor(T domElement) {
        return DomAnchorImpl.createAnchor(domElement);
    }

    @NotNull
    public XmlFile getContainingFile(@NotNull DomElement domElement) {
        if (domElement instanceof DomFileElement) {
            return ((DomFileElement)domElement).getFile();
        }
        return DomManagerImpl.getNotNullHandler(domElement).getFile();
    }

    @NotNull
    public EvaluatedXmlName getEvaluatedXmlName(@NotNull DomElement element) {
        return DomManagerImpl.getNotNullHandler(element).getXmlName();
    }

    @NotNull
    public XmlFileHeader getXmlFileHeader(XmlFile file2) {
        return file2.isValid() ? (XmlFileHeader)((CachedValue)ourRootTagCache.get(ROOT_TAG_NS_KEY, (UserDataHolder)file2, null)).getValue() : XmlFileHeader.EMPTY;
    }

    public Collection<VirtualFile> getDomFileCandidates(Class<? extends DomElement> rootElementClass, Project project2, GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(DomFileIndex.NAME, (Object)rootElementClass.getName(), scope);
    }

    public <T extends DomElement> List<DomFileElement<T>> getFileElements(Class<T> clazz, Project project2, @Nullable GlobalSearchScope scope) {
        Collection<VirtualFile> list = this.getDomFileCandidates(clazz, project2, scope != null ? scope : GlobalSearchScope.allScope((Project)project2));
        ArrayList<DomFileElement<T>> result2 = new ArrayList<DomFileElement<T>>(list.size());
        for (VirtualFile file2 : list) {
            DomFileElement element;
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file2);
            if (!(psiFile instanceof XmlFile) || (element = DomManager.getDomManager((Project)project2).getFileElement((XmlFile)psiFile, clazz)) == null) continue;
            result2.add(element);
        }
        return result2;
    }

    public StructureViewBuilder createSimpleStructureViewBuilder(XmlFile file2, Function<DomElement, DomService.StructureViewMode> modeProvider) {
        return new DomStructureViewBuilder(file2, modeProvider);
    }
}

