/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.Implementation;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.SofterCache;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ImplementationClassCache {
    private static final Comparator<Class> CLASS_COMPARATOR = (o1, o2) -> {
        if (o1.isAssignableFrom((Class<?>)o2)) {
            return 1;
        }
        if (o2.isAssignableFrom((Class<?>)o1)) {
            return -1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        throw new AssertionError((Object)("Incompatible implementation classes: " + o1 + " & " + o2));
    };
    private final MultiMap<String, DomImplementationClassEP> myImplementationClasses = new MultiMap();
    private final SofterCache<Class, Class> myCache = SofterCache.create(new NotNullFunction<Class, Class>(){

        @NotNull
        public Class fun(Class dom) {
            return ImplementationClassCache.this.calcImplementationClass(dom);
        }
    });

    ImplementationClassCache(ExtensionPointName<DomImplementationClassEP> epName) {
        for (DomImplementationClassEP ep : (DomImplementationClassEP[])epName.getExtensions()) {
            this.myImplementationClasses.putValue((Object)ep.interfaceName, (Object)ep);
        }
    }

    private Class calcImplementationClass(Class concreteInterface) {
        TreeSet<Class> set2 = new TreeSet<Class>(CLASS_COMPARATOR);
        this.findImplementationClassDFS(concreteInterface, set2);
        if (!set2.isEmpty()) {
            return set2.first();
        }
        Implementation implementation = (Implementation)DomReflectionUtil.findAnnotationDFS((Class)concreteInterface, Implementation.class);
        return implementation == null ? concreteInterface : implementation.value();
    }

    private void findImplementationClassDFS(Class concreteInterface, SortedSet<Class> results) {
        Collection values = this.myImplementationClasses.get((Object)concreteInterface.getName());
        for (DomImplementationClassEP value2 : values) {
            if (value2.getInterfaceClass() != concreteInterface) continue;
            results.add(value2.getImplementationClass());
            return;
        }
        for (Class<?> aClass1 : concreteInterface.getInterfaces()) {
            this.findImplementationClassDFS(aClass1, results);
        }
    }

    public final void registerImplementation(final Class domElementClass, final Class implementationClass, @Nullable Disposable parentDisposable) {
        DomImplementationClassEP ep = new DomImplementationClassEP(){

            @Override
            public Class getInterfaceClass() {
                return domElementClass;
            }

            @Override
            public Class getImplementationClass() {
                return implementationClass;
            }
        };
        this.myImplementationClasses.putValue((Object)domElementClass.getName(), (Object)ep);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    ImplementationClassCache.this.myImplementationClasses.remove((Object)domElementClass.getName());
                }
            });
        }
        this.myCache.clearCache();
    }

    public Class get(Class key2) {
        Class impl = this.myCache.getCachedValue(key2);
        return impl == key2 ? null : impl;
    }
}

