/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import org.jetbrains.annotations.NotNull;

public class VirtualDomParentStrategy
implements DomParentStrategy {
    private final DomInvocationHandler myParentHandler;
    private long myModCount;
    private final PsiFile myModificationTracker;

    public VirtualDomParentStrategy(@NotNull DomInvocationHandler parentHandler) {
        this.myParentHandler = parentHandler;
        this.myModificationTracker = parentHandler.getFile();
        this.myModCount = this.getModCount();
    }

    private long getModCount() {
        return this.myModificationTracker.getModificationStamp();
    }

    @Override
    @NotNull
    public DomInvocationHandler getParentHandler() {
        return this.myParentHandler;
    }

    @Override
    public XmlElement getXmlElement() {
        return null;
    }

    @Override
    @NotNull
    public synchronized DomParentStrategy refreshStrategy(DomInvocationHandler handler2) {
        if (!this.myParentHandler.isValid()) {
            return this;
        }
        long modCount = this.getModCount();
        if (modCount != this.myModCount) {
            XmlElement xmlElement = handler2.recomputeXmlElement(this.myParentHandler);
            if (xmlElement != null) {
                return new PhysicalDomParentStrategy(xmlElement, DomManagerImpl.getDomManager(xmlElement.getProject()));
            }
            this.myModCount = modCount;
        }
        return this;
    }

    @Override
    @NotNull
    public DomParentStrategy setXmlElement(@NotNull XmlElement element) {
        return new PhysicalDomParentStrategy(element, DomManagerImpl.getDomManager(element.getProject()));
    }

    @Override
    @NotNull
    public synchronized DomParentStrategy clearXmlElement() {
        this.myModCount = this.getModCount();
        return this;
    }

    @Override
    public synchronized String checkValidity() {
        if (this.getModCount() == this.myModCount) {
            return null;
        }
        return "mod count changed";
    }

    @Override
    public XmlFile getContainingFile(DomInvocationHandler handler2) {
        return DomImplUtil.getFile(handler2);
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualDomParentStrategy)) {
            return false;
        }
        VirtualDomParentStrategy that = (VirtualDomParentStrategy)o;
        return this.myParentHandler.equals((Object)that.myParentHandler);
    }

    public int hashCode() {
        return this.myParentHandler.hashCode();
    }
}

