/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.util.SmartList;
import com.intellij.util.io.StringRef;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStubSerializer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementStub
extends DomStub {
    private final List<DomStub> myChildren = new SmartList();
    private final int myIndex;
    private final boolean myCustom;
    @Nullable
    private final StringRef myElementClass;
    private final String myValue;

    public ElementStub(@Nullable ElementStub parent, @NotNull StringRef name, @Nullable StringRef namespace, int index, boolean custom, @Nullable StringRef elementClass, @NotNull String value2) {
        super(parent, name, namespace);
        this.myIndex = index;
        this.myCustom = custom;
        this.myElementClass = elementClass;
        this.myValue = value2;
    }

    void addChild(DomStub child) {
        this.myChildren.add(child);
    }

    @Override
    @NotNull
    public List<DomStub> getChildrenStubs() {
        return this.myChildren;
    }

    public ObjectStubSerializer getStubType() {
        return ElementStubSerializer.INSTANCE;
    }

    public String toString() {
        String key2 = this.getNamespaceKey();
        return (StringUtil.isEmpty((String)key2) ? this.getName() : key2 + ":" + this.getName()) + (StringUtil.isEmpty((String)this.getValue()) ? "" : ":" + this.getValue());
    }

    @Override
    public boolean isCustom() {
        return this.myCustom;
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Nullable
    String getElementClass() {
        return this.myElementClass == null ? null : this.myElementClass.getString();
    }

    @NotNull
    public String getValue() {
        return this.myValue;
    }
}

