/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.util.xml.stubs.index.DomElementClassIndex;
import com.intellij.util.xml.stubs.index.DomNamespaceKeyIndex;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ElementStubSerializer
implements ObjectStubSerializer<ElementStub, ElementStub> {
    static final ObjectStubSerializer INSTANCE = new ElementStubSerializer();

    public void serialize(@NotNull ElementStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getNamespaceKey());
        dataStream.writeVarInt(stub.getIndex());
        dataStream.writeBoolean(stub.isCustom());
        dataStream.writeName(stub.getElementClass());
        dataStream.writeUTFFast(stub.getValue());
    }

    @NotNull
    public ElementStub deserialize(@NotNull StubInputStream dataStream, ElementStub parentStub) throws IOException {
        return new ElementStub(parentStub, dataStream.readName(), dataStream.readName(), dataStream.readVarInt(), dataStream.readBoolean(), dataStream.readName(), dataStream.readUTFFast());
    }

    public void indexStub(@NotNull ElementStub stub, @NotNull IndexSink sink) {
        String elementClass;
        String namespaceKey = stub.getNamespaceKey();
        if (StringUtil.isNotEmpty((String)namespaceKey)) {
            sink.occurrence(DomNamespaceKeyIndex.KEY, (Object)namespaceKey);
        }
        if ((elementClass = stub.getElementClass()) != null) {
            sink.occurrence(DomElementClassIndex.KEY, (Object)elementClass);
        }
    }

    @NotNull
    public String getExternalId() {
        return "ElementStubSerializer";
    }

    public String toString() {
        return "Element";
    }
}

