/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.stubs.FileStub;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileStubSerializer
implements ObjectStubSerializer<FileStub, Stub> {
    static final FileStubSerializer INSTANCE = new FileStubSerializer();

    @NotNull
    public String getExternalId() {
        return "FileStubSerializer";
    }

    public void serialize(@NotNull FileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        XmlFileHeader header = stub.getHeader();
        dataStream.writeName(header.getRootTagLocalName());
        dataStream.writeName(header.getRootTagNamespace());
        dataStream.writeName(header.getPublicId());
        dataStream.writeName(header.getSystemId());
    }

    @NotNull
    public FileStub deserialize(@NotNull StubInputStream dataStream, Stub parentStub) throws IOException {
        return new FileStub(dataStream.readName(), dataStream.readName(), dataStream.readName(), dataStream.readName());
    }

    public void indexStub(@NotNull FileStub stub, @NotNull IndexSink sink) {
    }

    public String toString() {
        return "File";
    }
}

